/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerHydroelectricGenerator;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.generators.GenericGeneratorTile;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileHydroelectricGenerator
extends GenericGeneratorTile
implements ITickableSound {
    protected CachedTileOutput output;
    public SingleProperty<Boolean> isGenerating = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isGenerating", (Object)false));
    public SingleProperty<Boolean> directionFlag = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "directionFlag", (Object)false));
    public SingleProperty<Double> multiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "multiplier", (Object)1.0));
    private SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
    public double savedTickRotation;
    public double rotationSpeed;
    private boolean isSoundPlaying = false;

    public TileHydroelectricGenerator(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_HYDROELECTRICGENERATOR.get(), worldPosition, blockState, 2.25, SubtypeItemUpgrade.stator);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickCommon(this::tickCommon).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().upgrades(1)).validUpgrades(ContainerHydroelectricGenerator.VALID_UPGRADES).valid(TileHydroelectricGenerator.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.hydroelectricgenerator.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerHydroelectricGenerator((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.isGenerating.setValue((Object)false);
            return;
        }
        Direction facing = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (tickable.getTicks() % 20L == 0L) {
            BlockPos shift = this.f_58858_.m_121945_(facing);
            BlockState onShift = this.f_58857_.m_8055_(shift);
            this.isGenerating.setValue((Object)(onShift.m_60819_().m_76152_() == Fluids.f_76192_ ? 1 : 0));
            if (((Boolean)this.isGenerating.getValue()).booleanValue() && onShift.m_60734_() instanceof LiquidBlock) {
                int amount = (Integer)this.f_58857_.m_8055_(shift).m_61143_((Property)LiquidBlock.f_54688_);
                shift = this.f_58858_.m_121945_(facing).m_121945_(facing.m_122427_());
                onShift = this.f_58857_.m_8055_(shift);
                if (onShift.m_60734_() instanceof LiquidBlock && amount > (Integer)onShift.m_61143_((Property)LiquidBlock.f_54688_)) {
                    this.directionFlag.setValue((Object)true);
                } else {
                    shift = this.f_58858_.m_121945_(facing).m_121945_(facing.m_122427_().m_122424_());
                    onShift = this.f_58857_.m_8055_(shift);
                    if (onShift.m_60734_() instanceof LiquidBlock && amount >= (Integer)onShift.m_61143_((Property)LiquidBlock.f_54688_)) {
                        this.directionFlag.setValue((Object)false);
                    } else {
                        this.isGenerating.setValue((Object)false);
                    }
                }
            }
            this.output.update(this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (((Boolean)this.isGenerating.getValue()).booleanValue() && this.output.valid()) {
            ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), facing, this.getProduced(), false);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        this.savedTickRotation += (double)((Boolean)this.directionFlag.getValue() != false ? 1 : -1) * this.rotationSpeed;
        this.rotationSpeed = Mth.m_14008_((double)(this.rotationSpeed + 0.05 * (double)((Boolean)this.isGenerating.getValue() != false ? 1 : -1)), (double)0.0, (double)1.0);
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.shouldPlaySound()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.3) {
            Direction direction = this.getFacing();
            double d4 = this.f_58857_.f_46441_.m_188500_();
            double d5 = direction.m_122434_() == Direction.Axis.X ? (double)direction.m_122429_() * (direction.m_122429_() == -1 ? 0.2 : 1.2) : d4;
            double d6 = this.f_58857_.f_46441_.m_188500_();
            double d7 = direction.m_122434_() == Direction.Axis.Z ? (double)direction.m_122431_() * (direction.m_122431_() == -1 ? 0.2 : 1.2) : d4;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123774_, (double)this.f_58858_.m_123341_() + d5, (double)this.f_58858_.m_123342_() + d6, (double)this.f_58858_.m_123343_() + d7, 0.0, 0.0, 0.0);
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HYDROELECTRICGENERATOR.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.isGenerating.getValue();
    }

    public void setMultiplier(double val) {
        this.multiplier.setValue((Object)val);
    }

    public double getMultiplier() {
        return (Double)this.multiplier.getValue();
    }

    public TransferPack getProduced() {
        return TransferPack.ampsVoltage((double)(ElectroConstants.HYDROELECTRICGENERATOR_AMPERAGE * ((Boolean)this.isGenerating.getValue() != false ? (Double)this.multiplier.getValue() : 0.0)), (double)((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getVoltage());
    }

    public int getComparatorSignal() {
        return (Boolean)this.isGenerating.getValue() != false ? 15 : 0;
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }

    public AABB getRenderBoundingBox() {
        Direction facing = this.getFacing();
        return super.getRenderBoundingBox().m_82363_((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
    }
}

