/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.quarry;

import com.mojang.datafixers.util.Pair;
import electrodynamics.client.event.levelstage.HandlerQuarryArm;
import electrodynamics.common.item.subtype.SubtypeDrillHead;
import electrodynamics.common.tile.machines.quarry.TileQuarry;
import electrodynamics.prefab.utilities.object.QuarryArmDataHolder;
import electrodynamics.prefab.utilities.object.QuarryArmFrameWrapper;
import electrodynamics.prefab.utilities.object.QuarryWheelDataHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.math.PrecisionVector;
import voltaic.prefab.utilities.object.Location;

public class QuarryRenderManger {
    private QuarryArmFrameWrapper currentFrame = null;
    private boolean onRight = false;

    public void render(TileQuarry quarry) {
        BlockPos pos = quarry.m_58899_();
        HandlerQuarryArm.removeRenderData(pos);
        if (!quarry.hasCorners() || quarry.miningPos.getValue() == null || ((BlockPos)quarry.miningPos.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
            return;
        }
        this.onRight = (Boolean)quarry.cornerOnRight.getValue();
        this.currentFrame = this.getCurrentFrame(quarry);
        if (this.currentFrame == null) {
            return;
        }
        BlockPos start = (BlockPos)((List)quarry.corners.getValue()).get(3);
        BlockPos end = (BlockPos)((List)quarry.corners.getValue()).get(0);
        AABB headAabb = null;
        PrecisionVector headPos = null;
        QuarryWheelDataHolder leftWheel = null;
        QuarryWheelDataHolder rightWheel = null;
        QuarryWheelDataHolder topWheel = null;
        QuarryWheelDataHolder bottomWheel = null;
        ArrayList<Pair<PrecisionVector, AABB>> lightSegments = new ArrayList<Pair<PrecisionVector, AABB>>();
        ArrayList<Pair<PrecisionVector, AABB>> darkSegments = new ArrayList<Pair<PrecisionVector, AABB>>();
        ArrayList<Pair<PrecisionVector, AABB>> titanium = new ArrayList<Pair<PrecisionVector, AABB>>();
        double x = this.currentFrame.frame().x();
        double z = this.currentFrame.frame().z();
        double y = (double)start.m_123342_() + 0.5;
        double deltaY = (double)start.m_123342_() - this.currentFrame.frame().y() - 1.2;
        QuarryRenderManger.vertical(x, y, z, deltaY, darkSegments, lightSegments, titanium);
        SubtypeDrillHead headType = quarry.readHeadType();
        if (headType != null) {
            headPos = new PrecisionVector(x, y - deltaY, z);
            headAabb = new AABB(0.3125, -0.2, 0.3125, 0.6875, -0.7, 0.6875);
        }
        Direction facing = quarry.getFacing().m_122424_();
        int[] markerLineSigns = new int[]{1, 1, -1, -1};
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                double widthLeft = x - (double)start.m_123341_();
                double widthRight = x - (double)end.m_123341_();
                double widthTop = z - (double)start.m_123343_();
                double widthBottom = z - (double)end.m_123343_();
                int wholeWidthLeft = (int)(widthLeft / 1.0);
                double remainderWidthLeft = widthLeft - (double)wholeWidthLeft;
                int wholeWidthRight = (int)(widthRight / 1.0);
                double remainderWidthRight = widthRight - (double)wholeWidthRight;
                int wholeWidthBottom = (int)(widthBottom / 1.0);
                double remainderWidthBottom = widthBottom - (double)wholeWidthBottom;
                int wholeWidthTop = (int)(widthTop / 1.0);
                double remainderWidthTop = widthTop - (double)wholeWidthTop;
                if (facing == Direction.SOUTH) {
                    this.south(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, widthTop, widthBottom, wholeWidthLeft, wholeWidthRight, wholeWidthTop, wholeWidthBottom, remainderWidthLeft, remainderWidthRight, remainderWidthTop, remainderWidthBottom);
                    if (this.onRight) {
                        leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthLeft + 0.5, y, z + 0.5), 0, this.currentFrame.degrees() * (float)this.currentFrame.deltaZ(), 0.0f);
                        rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthRight + 0.5, y, z + 0.5), 180, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaZ()), 0.0f);
                    } else {
                        leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthLeft + 0.5, y, z + 0.5), 180, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaZ()), 0.0f);
                        rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthRight + 0.5, y, z + 0.5), 0, this.currentFrame.degrees() * (float)this.currentFrame.deltaZ(), 0.0f);
                    }
                    bottomWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthBottom + 0.5), 270, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaX()), 0.0f);
                    topWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthTop + 0.5), 90, this.currentFrame.degrees() * (float)this.currentFrame.deltaX(), 0.0f);
                    break;
                }
                this.north(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, widthTop, widthBottom, wholeWidthLeft, wholeWidthRight, wholeWidthTop, wholeWidthBottom, remainderWidthLeft, remainderWidthRight, remainderWidthTop, remainderWidthBottom);
                if (this.onRight) {
                    leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthLeft + 0.5, y, z + 0.5), 180, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaZ()), 0.0f);
                    rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthRight + 0.5, y, z + 0.5), 0, this.currentFrame.degrees() * (float)this.currentFrame.deltaZ(), 0.0f);
                } else {
                    leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthLeft + 0.5, y, z + 0.5), 0, this.currentFrame.degrees() * (float)this.currentFrame.deltaZ(), 0.0f);
                    rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthRight + 0.5, y, z + 0.5), 180, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaZ()), 0.0f);
                }
                bottomWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthBottom + 0.5), 90, this.currentFrame.degrees() * (float)this.currentFrame.deltaX(), 0.0f);
                topWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthTop + 0.5), 270, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaX()), 0.0f);
                break;
            }
            case EAST: 
            case WEST: {
                double widthLeft = z - (double)start.m_123343_();
                double widthRight = z - (double)end.m_123343_();
                double widthTop = x - (double)start.m_123341_();
                double widthBottom = x - (double)end.m_123341_();
                int wholeWidthLeft = (int)(widthLeft / 1.0);
                double remainderWidthLeft = widthLeft - (double)wholeWidthLeft;
                int wholeWidthRight = (int)(widthRight / 1.0);
                double remainderWidthRight = widthRight - (double)wholeWidthRight;
                int wholeWidthBottom = (int)(widthBottom / 1.0);
                double remainderWidthBottom = widthBottom - (double)wholeWidthBottom;
                int wholeWidthTop = (int)(widthTop / 1.0);
                double remainderWidthTop = widthTop - (double)wholeWidthTop;
                if (facing == Direction.WEST) {
                    this.west(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, widthTop, widthBottom, wholeWidthLeft, wholeWidthRight, wholeWidthTop, wholeWidthBottom, remainderWidthLeft, remainderWidthRight, remainderWidthTop, remainderWidthBottom);
                    if (this.onRight) {
                        leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthLeft + 0.5), 270, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaX()), 0.0f);
                        rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthRight + 0.5), 90, this.currentFrame.degrees() * (float)this.currentFrame.deltaX(), 0.0f);
                    } else {
                        leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthLeft + 0.5), 90, this.currentFrame.degrees() * (float)this.currentFrame.deltaX(), 0.0f);
                        rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthRight + 0.5), 270, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaX()), 0.0f);
                    }
                    bottomWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthBottom + 0.5, y, z + 0.5), 180, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaZ()), 0.0f);
                    topWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthTop + 0.5, y, z + 0.5), 0, this.currentFrame.degrees() * (float)this.currentFrame.deltaZ(), 0.0f);
                    break;
                }
                this.east(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, widthTop, widthBottom, wholeWidthLeft, wholeWidthRight, wholeWidthTop, wholeWidthBottom, remainderWidthLeft, remainderWidthRight, remainderWidthTop, remainderWidthBottom);
                if (this.onRight) {
                    leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthLeft + 0.5), 90, this.currentFrame.degrees() * (float)this.currentFrame.deltaX(), 0.0f);
                    rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthRight + 0.5), 270, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaX()), 0.0f);
                } else {
                    leftWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthLeft + 0.5), 270, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaX()), 0.0f);
                    rightWheel = new QuarryWheelDataHolder(new PrecisionVector(x + 0.5, y, z - widthRight + 0.5), 90, this.currentFrame.degrees() * (float)this.currentFrame.deltaX(), 0.0f);
                }
                bottomWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthBottom + 0.5, y, z + 0.5), 0, this.currentFrame.degrees() * (float)this.currentFrame.deltaZ(), 0.0f);
                topWheel = new QuarryWheelDataHolder(new PrecisionVector(x - widthTop + 0.5, y, z + 0.5), 180, this.currentFrame.degrees() * (float)(-this.currentFrame.deltaZ()), 0.0f);
                break;
            }
        }
        HandlerQuarryArm.addRenderData(pos, new QuarryArmDataHolder(lightSegments, darkSegments, titanium, (Pair<PrecisionVector, AABB>)Pair.of((Object)headPos, (Object)headAabb), headType, leftWheel, rightWheel, topWheel, bottomWheel, (Boolean)quarry.running.getValue(), (Integer)quarry.progressCounter.getValue(), (Integer)quarry.speed.getValue(), (List)quarry.corners.getValue(), markerLineSigns));
    }

    private static void vertical(double x, double y, double z, double deltaY, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, List<Pair<PrecisionVector, AABB>> titanium) {
        int i = 0;
        PrecisionVector pos = null;
        int wholeSegmentCount = (int)(deltaY / 1.0);
        double remainder = deltaY / 1.0 - (double)wholeSegmentCount;
        for (i = 0; i < wholeSegmentCount; ++i) {
            pos = new PrecisionVector(x, y - (double)i * 1.0 - 0.3125, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.0, 0.25, 0.3125, -1.0, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.0, 0.6875, 0.3125, -1.0, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.0, 0.25, 0.75, -1.0, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.0, 0.6875, 0.75, -1.0, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.53125, 0.3125, 0.3125, -0.46875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.53125, 0.6875, 0.6875, -0.46875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.53125, 0.3125, 0.75, -0.46875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.53125, 0.25, 0.6875, -0.46875, 0.3125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, 0.0, 0.375, 0.625, -1.0, 0.625)));
        }
        int wholeOffset = wholeSegmentCount;
        pos = new PrecisionVector(x, y - (double)wholeOffset, z);
        if (remainder > 0.0) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.3125, 0.25, 0.3125, -1.0 * remainder, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.3125, 0.6875, 0.3125, -1.0 * remainder, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.3125, 0.25, 0.75, -1.0 * remainder, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.3125, 0.6875, 0.75, -1.0 * remainder, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.3125, 0.375, 0.625, -1.0 * remainder, 0.625)));
            if (remainder > 0.5) {
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.78125, 0.3125, 0.3125, -0.71875, 0.6875)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.78125, 0.6875, 0.6875, -0.71875, 0.75)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.78125, 0.3125, 0.75, -0.71875, 0.6875)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.78125, 0.25, 0.6875, -0.71875, 0.3125)));
            }
        }
        titanium.add((Pair<PrecisionVector, AABB>)Pair.of((Object)new PrecisionVector(x, y, z), (Object)new AABB(0.1875, 0.325, 0.1875, 0.8125, -0.325, 0.8125)));
        if (remainder > 0.0) {
            titanium.add((Pair<PrecisionVector, AABB>)Pair.of((Object)new PrecisionVector(x, y - deltaY, z), (Object)new AABB(0.2, 0.0, 0.2, 0.8, -0.2, 0.8)));
        }
    }

    private void north(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, double widthTop, double widthBottom, int wholeWidthLeft, int wholeWidthRight, int wholeWidthTop, int wholeWidthBottom, double remainderWidthLeft, double remainderWidthRight, double remainderWidthTop, double remainderWidthBottom) {
        int i;
        int removal;
        if (this.onRight) {
            QuarryRenderManger.northOnRight(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        } else {
            QuarryRenderManger.northOnLeft(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        }
        PrecisionVector pos = null;
        int n = removal = remainderWidthBottom > -0.625 ? 1 : 0;
        for (i = 0; i > wholeWidthBottom + removal; --i) {
            pos = new PrecisionVector(x, y, z - widthBottom + 1.0 * (double)i + 0.1875);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, -1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.125, 0.0, 0.625, 0.125, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, -0.9375, 0.3125, 0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, -0.9375, 0.75, 0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, -0.9375, 0.6875, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, -0.9375, 0.6875, 0.25, -1.0)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthBottom + 1.0 + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthBottom + 1.0 + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthBottom + 1.0 + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthBottom + 1.0 + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.125, -remainderWidthBottom + 1.0 + 0.1875, 0.625, 0.125, 0.8125)));
            if (remainderWidthBottom < -0.375) {
                pos = new PrecisionVector(x, y, z - remainderWidthBottom - 1.0 + 0.1875);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 1.0, 0.3125, 0.1875, 1.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 1.0, 0.75, 0.1875, 1.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 1.0, 0.6875, -0.1875, 1.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 1.0, 0.6875, 0.25, 1.0625)));
            }
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthBottom + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthBottom + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthBottom + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthBottom + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.125, -remainderWidthBottom + 0.1875, 0.625, 0.125, 0.8125)));
        }
        removal = remainderWidthTop < 0.625 ? 1 : 0;
        for (i = 0; i < wholeWidthTop - removal; ++i) {
            pos = new PrecisionVector(x, y, z - widthTop + 1.0 * (double)i + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 1.0, 0.3125, -0.1875, 0.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 1.0, 0.3125, 0.25, 0.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 1.0, 0.75, -0.1875, 0.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 1.0, 0.75, 0.25, 0.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 1.0, 0.625, 0.125, 0.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -0.1875 - remainderWidthTop, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -0.1875 - remainderWidthTop, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -0.1875 - remainderWidthTop, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -0.1875 - remainderWidthTop, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -0.1875 - remainderWidthTop, 0.625, 0.125, 0.1875)));
            if (remainderWidthTop > 0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthTop - 1.0 + 0.8125);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
            }
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.1875, 0.3125, -0.1875, 0.8125 - remainderWidthTop)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.1875, 0.75, -0.1875, 0.8125 - remainderWidthTop)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.1875, 0.3125, 0.25, 0.8125 - remainderWidthTop)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.1875, 0.75, 0.25, 0.8125 - remainderWidthTop)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.1875, 0.625, 0.125, 0.8125 - remainderWidthTop)));
        }
    }

    private static void northOnRight(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        int i;
        PrecisionVector pos = null;
        for (i = 1; i > wholeWidthLeft + 2; --i) {
            pos = new PrecisionVector(x - widthLeft + 1.0 * (double)i - 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.25, 0.25, 0.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.25, 0.6875, 0.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.25, 0.25, 0.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.25, 0.6875, 0.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.125, 0.375, 0.0, -0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.25, 0.3125, -1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, 0.1875, 0.3125, -1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, 0.25, 0.25, 0.8125, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, 0.25, 0.6875, 0.8125, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, -0.25, 0.25, 0.8125, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, -0.25, 0.6875, 0.8125, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, 0.125, 0.375, 0.8125, -0.125, 0.625)));
        if (remainderWidthLeft < -0.5) {
            pos = new PrecisionVector(x - remainderWidthLeft + 1.0 + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.25, 0.3125, -1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, 0.1875, 0.3125, -1.0, 0.25, 0.6875)));
        }
        for (i = 0; i < wholeWidthRight - 1; ++i) {
            pos = new PrecisionVector(x - widthRight + 1.0 * (double)i + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, 1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, 1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.125, 0.375, 1.0, -0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, 0.25, 0.25, 0.1875, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, 0.25, 0.6875, 0.1875, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, -0.25, 0.25, 0.1875, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, -0.25, 0.6875, 0.1875, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, 0.125, 0.375, 0.1875, -0.125, 0.625)));
        if (remainderWidthRight > 0.5) {
            pos = new PrecisionVector(x - remainderWidthRight - 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
    }

    private static void northOnLeft(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        int i;
        PrecisionVector pos = null;
        for (i = wholeWidthLeft - 1; i > 0; --i) {
            pos = new PrecisionVector(x - widthLeft + 1.0 * (double)i - 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, 1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, 1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.125, 0.375, 1.0, -0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 0.1875, 0.25, 0.25, 0.1875, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 0.1875, 0.25, 0.6875, 0.1875, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 0.1875, -0.25, 0.25, 0.1875, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 0.1875, -0.25, 0.6875, 0.1875, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 0.1875, 0.125, 0.375, 0.1875, -0.125, 0.625)));
        if (remainderWidthLeft > 0.5) {
            pos = new PrecisionVector(x - remainderWidthLeft - 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        for (i = 0; i > wholeWidthRight + 1; --i) {
            pos = new PrecisionVector(x - widthRight + 1.0 * (double)i + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, -1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, -1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.125, 0.375, -1.0, -0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.25, -0.9375, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.6875, -0.9375, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.25, 0.3125, -0.9375, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.1875, 0.3125, -0.9375, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, 0.25, 0.25, 0.8125, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, 0.25, 0.6875, 0.8125, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, -0.25, 0.25, 0.8125, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, -0.25, 0.6875, 0.8125, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, 0.125, 0.375, 0.8125, -0.125, 0.625)));
        if (remainderWidthRight < -0.5) {
            pos = new PrecisionVector(x - remainderWidthRight + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.25, 0.0625, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.6875, 0.0625, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.3125, 0.0625, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.3125, 0.0625, 0.25, 0.6875)));
        }
    }

    private void south(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, double widthTop, double widthBottom, int wholeWidthLeft, int wholeWidthRight, int wholeWidthTop, int wholeWidthBottom, double remainderWidthLeft, double remainderWidthRight, double remainderWidthTop, double remainderWidthBottom) {
        PrecisionVector pos;
        int i;
        int removal;
        if (this.onRight) {
            QuarryRenderManger.southOnRight(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        } else {
            QuarryRenderManger.southOnLeft(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        }
        int n = removal = remainderWidthBottom < 0.625 ? 1 : 0;
        for (i = 0; i < wholeWidthBottom - removal; ++i) {
            pos = new PrecisionVector(x, y, z - widthBottom + 1.0 * (double)i + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, 1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.125, 0.0, 0.625, 0.125, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 0) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthBottom + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthBottom + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthBottom + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthBottom + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.125, -remainderWidthBottom + 0.8125, 0.625, 0.125, 0.1875)));
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthBottom - 1.0 + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthBottom - 1.0 + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthBottom - 1.0 + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthBottom - 1.0 + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.375, -0.125, -remainderWidthBottom - 1.0 + 0.8125, 0.625, 0.125, 0.1875)));
            if (remainderWidthBottom > 0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthBottom - 1.0 + 0.8125);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
            }
        }
        removal = remainderWidthTop > -0.625 ? 1 : 0;
        for (i = 0; i > wholeWidthTop + removal; --i) {
            pos = new PrecisionVector(x, y, z - widthTop + 1.0 * (double)i + 0.1875);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, -1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, -1.0, 0.3125, 0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, -1.0, 0.75, 0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, -1.0, 0.6875, -0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, -1.0, 0.6875, 0.25, -0.9375)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthTop + 1.0 + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthTop + 1.0 + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthTop + 1.0 + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthTop + 1.0 + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthTop + 1.0 + 0.1875, 0.625, 0.125, 0.8125)));
            if (remainderWidthTop < -0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthTop + 0.1875);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.0, 0.3125, 0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.0, 0.75, 0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.0, 0.6875, -0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.0, 0.6875, 0.25, 0.0625)));
            }
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthTop + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthTop + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthTop + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthTop + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthTop + 0.1875, 0.625, 0.125, 0.8125)));
        }
    }

    private static void southOnRight(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        PrecisionVector pos;
        int i;
        for (i = 0; i < wholeWidthLeft - 1; ++i) {
            pos = new PrecisionVector(x - widthLeft + 1.0 * (double)i + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, 1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, 1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.125, 0.375, 1.0, 0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 1.0 + 0.8125, 0.25, 0.25, 0.25, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 1.0 + 0.8125, 0.25, 0.6875, 0.25, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 1.0 + 0.8125, -0.25, 0.25, 0.25, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 1.0 + 0.8125, -0.25, 0.6875, 0.25, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft - 1.0 + 0.8125, -0.125, 0.375, 0.25, 0.125, 0.625)));
        if (remainderWidthLeft > 0.5) {
            pos = new PrecisionVector(x - remainderWidthLeft - 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        for (i = 0; i > wholeWidthRight + 1; --i) {
            pos = new PrecisionVector(x - widthRight + 1.0 * (double)i + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, -1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, -1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.125, 0.375, -1.0, -0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.25, -0.9375, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.6875, -0.9375, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.25, 0.3125, -0.9375, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.1875, 0.3125, -0.9375, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, 0.25, 0.25, 0.75, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, 0.25, 0.6875, 0.75, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, -0.25, 0.25, 0.75, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, -0.25, 0.6875, 0.75, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight + 1.0 + 0.1875, -0.125, 0.375, 0.75, 0.125, 0.625)));
        if (remainderWidthRight < -0.5) {
            pos = new PrecisionVector(x - remainderWidthRight + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.25, 0.0625, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.6875, 0.0625, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.3125, 0.0625, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.3125, 0.0625, 0.25, 0.6875)));
        }
    }

    private static void southOnLeft(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        PrecisionVector pos;
        int i;
        for (i = 0; i > wholeWidthLeft + 1; --i) {
            pos = new PrecisionVector(x - widthLeft + 1.0 * (double)i + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, -1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, -1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.125, 0.375, -1.0, 0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.25, 0.3125, -1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, 0.1875, 0.3125, -1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, 0.25, 0.25, 0.8125, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, 0.25, 0.6875, 0.8125, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, -0.25, 0.25, 0.8125, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, -0.25, 0.6875, 0.8125, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthLeft + 1.0 + 0.1875, 0.125, 0.375, 0.8125, -0.125, 0.625)));
        if (remainderWidthLeft < -0.5) {
            pos = new PrecisionVector(x - remainderWidthLeft + 1.0 + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.25, -1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.1875, 0.6875, -1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, -0.25, 0.3125, -1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-0.9375, 0.1875, 0.3125, -1.0, 0.25, 0.6875)));
        }
        for (i = 0; i < wholeWidthRight - 1; ++i) {
            pos = new PrecisionVector(x - widthRight + 1.0 * (double)i + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.25, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, 1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, 1.0, -0.1875, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.125, 0.375, 1.0, -0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, 0.25, 0.25, 0.1875, 0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, 0.25, 0.6875, 0.1875, 0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, -0.25, 0.25, 0.1875, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, -0.25, 0.6875, 0.1875, -0.1875, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthRight - 1.0 + 0.8125, 0.125, 0.375, 0.1875, -0.125, 0.625)));
        if (remainderWidthRight > 0.5) {
            pos = new PrecisionVector(x - remainderWidthRight - 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
    }

    private void east(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, double widthTop, double widthBottom, int wholeWidthLeft, int wholeWidthRight, int wholeWidthTop, int wholeWidthBottom, double remainderWidthLeft, double remainderWidthRight, double remainderWidthTop, double remainderWidthBottom) {
        PrecisionVector pos;
        int i;
        if (this.onRight) {
            QuarryRenderManger.eastOnRight(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        } else {
            QuarryRenderManger.eastOnLeft(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        }
        for (i = 0; i < wholeWidthBottom - 1; ++i) {
            pos = new PrecisionVector(x - widthBottom + (double)i * 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, 1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, 1.0, -0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.25, 1.0, 0.25, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.6875, 1.0, 0.25, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.125, 0.3875, 1.0, 0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.8125 - 1.0, -0.25, 0.25, 0.1875, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.8125 - 1.0, -0.25, 0.6875, 0.1875, -0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.8125 - 1.0, 0.1875, 0.25, 0.1875, 0.25, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.8125 - 1.0, 0.1875, 0.6875, 0.1875, 0.25, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.8125 - 1.0, -0.125, 0.3875, 0.1875, 0.125, 0.625)));
        if (remainderWidthBottom > 0.5) {
            pos = new PrecisionVector(x - remainderWidthBottom - 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
        }
        for (i = 0; i > wholeWidthTop + 1; --i) {
            pos = new PrecisionVector(x - widthTop + (double)i * 1.0 + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, -1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, -1.0, -0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.25, -1.0, 0.25, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.6875, -1.0, 0.25, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.125, 0.3875, -1.0, 0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.25, -0.9375, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.6875, -0.9375, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.25, 0.3125, -0.9375, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.1875, 0.3125, -0.9375, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop + 1.0 + 0.1875, -0.25, 0.25, 0.8125, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop + 1.0 + 0.1875, -0.25, 0.6875, 0.8125, -0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop + 1.0 + 0.1875, 0.1875, 0.25, 0.8125, 0.25, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop + 1.0 + 0.1875, 0.1875, 0.6875, 0.8125, 0.25, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop + 1.0 + 0.1875, -0.125, 0.3875, 0.8125, 0.125, 0.625)));
        if (remainderWidthTop < -0.5) {
            pos = new PrecisionVector(x - remainderWidthTop + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.25, 0.0625, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.6875, 0.0625, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.3125, 0.0625, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.3125, 0.0625, 0.25, 0.6875)));
        }
    }

    private static void eastOnRight(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        PrecisionVector pos;
        int i;
        int removal;
        int n = removal = remainderWidthLeft < -0.625 ? 1 : 0;
        for (i = 0; i > wholeWidthLeft + 1 - removal; --i) {
            pos = new PrecisionVector(x, y, z - widthLeft + (double)i * 1.0 + 0.1875);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, -1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, -1.0, 0.6875, -0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, -1.0, 0.6875, 0.25, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, -1.0, 0.3125, 0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, -1.0, 0.75, 0.1875, -0.9375)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft + 0.1875, 0.625, 0.125, 0.8125)));
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft + 1.0 + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft + 1.0 + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft + 1.0 + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft + 1.0 + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft + 1.0 + 0.1875, 0.625, 0.125, 0.8125)));
            if (remainderWidthLeft < -0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthLeft + 0.1875);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.0, 0.6875, -0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.0, 0.6875, 0.25, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.0, 0.3125, 0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.0, 0.75, 0.1875, 0.0625)));
            }
        }
        int n2 = removal = remainderWidthRight < 0.625 ? 1 : 0;
        for (i = 0; i < wholeWidthRight - removal; ++i) {
            pos = new PrecisionVector(x, y, z - widthRight + 1.0 * (double)i + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, 1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.468765, 0.6875, -0.1875, 0.53215)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.468765, 0.6875, 0.25, 0.53215)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.468765, 0.3125, 0.1875, 0.53215)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.468765, 0.75, 0.1875, 0.53215)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthRight - 1.0 + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthRight - 1.0 + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthRight - 1.0 + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthRight - 1.0 + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthRight - 1.0 + 0.8125, 0.625, 0.125, 0.1875)));
            pos = new PrecisionVector(x, y, z - remainderWidthRight - 1.0 + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.468765, 0.6875, -0.1875, 0.53215)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.468765, 0.6875, 0.25, 0.53215)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.468765, 0.3125, 0.1875, 0.53215)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.468765, 0.75, 0.1875, 0.53215)));
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthRight + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthRight + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthRight + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthRight + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthRight + 0.8125, 0.625, 0.125, 0.1875)));
        }
    }

    private static void eastOnLeft(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        PrecisionVector pos;
        int i;
        int removal;
        int n = removal = remainderWidthLeft < 0.625 ? 1 : 0;
        for (i = 0; i < wholeWidthLeft - removal; ++i) {
            pos = new PrecisionVector(x, y, z - widthLeft + (double)i * 1.0 + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, 1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft - 1.0 + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft - 1.0 + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft - 1.0 + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft - 1.0 + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft - 1.0 + 0.8125, 0.625, 0.125, 0.1875)));
            if (remainderWidthLeft > 0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthLeft - 1.0 + 0.8125);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
            }
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft + 0.8125, 0.625, 0.125, 0.1875)));
        }
        int n2 = removal = remainderWidthRight < -0.625 ? 1 : 0;
        for (i = 0; i > wholeWidthRight + 1 - removal; --i) {
            pos = new PrecisionVector(x, y, z - widthRight + 1.0 * (double)i + 0.1875);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, -1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, -1.0, 0.6875, -0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, -1.0, 0.6875, 0.25, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, -1.0, 0.3125, 0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, -1.0, 0.75, 0.1875, -0.9375)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthRight + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthRight + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthRight + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthRight + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthRight + 0.1875, 0.625, 0.125, 0.8125)));
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 1.0 - remainderWidthRight + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 1.0 - remainderWidthRight + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 1.0 - remainderWidthRight + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 1.0 - remainderWidthRight + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 1.0 - remainderWidthRight + 0.1875, 0.625, 0.125, 0.8125)));
            if (remainderWidthRight < -0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthRight + 0.1875);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.0, 0.6875, -0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.0, 0.6875, 0.25, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.0, 0.3125, 0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.0, 0.75, 0.1875, 0.0625)));
            }
        }
    }

    private void west(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, double widthTop, double widthBottom, int wholeWidthLeft, int wholeWidthRight, int wholeWidthTop, int wholeWidthBottom, double remainderWidthLeft, double remainderWidthRight, double remainderWidthTop, double remainderWidthBottom) {
        PrecisionVector pos;
        int i;
        if (this.onRight) {
            QuarryRenderManger.westOnRight(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        } else {
            QuarryRenderManger.westOnLeft(x, y, z, darkSegments, lightSegments, widthLeft, widthRight, wholeWidthLeft, wholeWidthRight, remainderWidthLeft, remainderWidthRight);
        }
        for (i = 0; i > wholeWidthBottom + 1; --i) {
            pos = new PrecisionVector(x - widthBottom + (double)i * 1.0 + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, -1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, -1.0, -0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.25, -1.0, 0.25, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.6875, -1.0, 0.25, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.125, 0.3875, -1.0, 0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.25, 0.3125, -0.9375, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, 0.1875, 0.3125, -0.9375, 0.25, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.25, -0.9375, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-1.0, -0.1875, 0.6875, -0.9375, 0.1875, 0.75)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.1875 + 1.0, -0.25, 0.25, 0.8125, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.1875 + 1.0, -0.25, 0.6875, 0.8125, -0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.1875 + 1.0, 0.1875, 0.25, 0.8125, 0.25, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.1875 + 1.0, 0.1875, 0.6875, 0.8125, 0.25, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthBottom + 0.1875 + 1.0, -0.125, 0.3875, 0.8125, 0.125, 0.625)));
        if (remainderWidthBottom < -0.5) {
            pos = new PrecisionVector(x - remainderWidthBottom + 0.1875, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.3125, 0.0625, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.3125, 0.0625, 0.25, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.25, 0.0625, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.1875, 0.6875, 0.0625, 0.1875, 0.75)));
        }
        for (i = 0; i < wholeWidthTop - 1; ++i) {
            pos = new PrecisionVector(x - widthTop + (double)i * 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.25, 1.0, -0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.25, 0.6875, 1.0, -0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.25, 1.0, 0.25, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, 0.1875, 0.6875, 1.0, 0.25, 0.75)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.0, -0.125, 0.3875, 1.0, 0.125, 0.625)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
        pos = new PrecisionVector(x, y, z);
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop - 1.0 + 0.8125, -0.25, 0.25, 0.1875, -0.1875, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop - 1.0 + 0.8125, -0.25, 0.6875, 0.1875, -0.1875, 0.75)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop - 1.0 + 0.8125, 0.1875, 0.25, 0.1875, 0.25, 0.3125)));
        lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop - 1.0 + 0.8125, 0.1875, 0.6875, 0.1875, 0.25, 0.75)));
        darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(-remainderWidthTop - 1.0 + 0.8125, -0.125, 0.3875, 0.1875, 0.125, 0.625)));
        if (remainderWidthTop > 0.5) {
            pos = new PrecisionVector(x - remainderWidthTop - 1.0 + 0.8125, y, z);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.25, 1.0, 0.1875, 0.3125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.1875, 0.6875, 1.0, 0.1875, 0.75)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, -0.25, 0.3125, 1.0, -0.1875, 0.6875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.9375, 0.1875, 0.3125, 1.0, 0.25, 0.6875)));
        }
    }

    private static void westOnRight(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        PrecisionVector pos;
        int i;
        int removal;
        int n = removal = remainderWidthLeft < 0.625 ? 1 : 0;
        for (i = 0; i < wholeWidthLeft - removal; ++i) {
            pos = new PrecisionVector(x, y, z - widthLeft + (double)i * 1.0 + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, 1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft - 1.0 + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft - 1.0 + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft - 1.0 + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft - 1.0 + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft - 1.0 + 0.8125, 0.625, 0.125, 0.1875)));
            if (remainderWidthLeft > 0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthLeft - 1.0 + 0.8125);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
            }
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft + 0.8125, 0.625, 0.125, 0.1875)));
        }
        int n2 = removal = remainderWidthRight < -0.625 ? 1 : 0;
        for (i = 0; i > wholeWidthRight + 1 - removal; --i) {
            pos = new PrecisionVector(x, y, z - widthRight + 1.0 * (double)i + 0.1875);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, -1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, -1.0, 0.6875, -0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, -1.0, 0.6875, 0.25, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, -1.0, 0.3125, 0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, -1.0, 0.75, 0.1875, -0.9375)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthRight + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthRight + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthRight + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthRight + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthRight + 0.1875, 0.625, 0.125, 0.8125)));
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 1.0 - remainderWidthRight + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 1.0 - remainderWidthRight + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 1.0 - remainderWidthRight + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 1.0 - remainderWidthRight + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 1.0 - remainderWidthRight + 0.1875, 0.625, 0.125, 0.8125)));
            if (remainderWidthRight < -0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthRight + 0.1875);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.0, 0.6875, -0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.0, 0.6875, 0.25, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.0, 0.3125, 0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.0, 0.75, 0.1875, 0.0625)));
            }
        }
    }

    private static void westOnLeft(double x, double y, double z, List<Pair<PrecisionVector, AABB>> darkSegments, List<Pair<PrecisionVector, AABB>> lightSegments, double widthLeft, double widthRight, int wholeWidthLeft, int wholeWidthRight, double remainderWidthLeft, double remainderWidthRight) {
        PrecisionVector pos;
        int i;
        int removal;
        int n = removal = remainderWidthLeft < -0.625 ? 1 : 0;
        for (i = 0; i > wholeWidthLeft + 1 - removal; --i) {
            pos = new PrecisionVector(x, y, z - widthLeft + (double)i * 1.0 + 0.1875);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, -1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, -1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, -1.0, 0.6875, -0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, -1.0, 0.6875, 0.25, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, -1.0, 0.3125, 0.1875, -0.9375)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, -1.0, 0.75, 0.1875, -0.9375)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft + 0.1875, 0.625, 0.125, 0.8125)));
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthLeft + 1.0 + 0.1875, 0.3125, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthLeft + 1.0 + 0.1875, 0.3125, 0.25, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthLeft + 1.0 + 0.1875, 0.75, -0.1875, 0.8125)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthLeft + 1.0 + 0.1875, 0.75, 0.25, 0.8125)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthLeft + 1.0 + 0.1875, 0.625, 0.125, 0.8125)));
            if (remainderWidthLeft < -0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthLeft + 0.1875);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.0, 0.6875, -0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.0, 0.6875, 0.25, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.0, 0.3125, 0.1875, 0.0625)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.0, 0.75, 0.1875, 0.0625)));
            }
        }
        int n2 = removal = remainderWidthRight < 0.625 ? 1 : 0;
        for (i = 0; i < wholeWidthRight - removal; ++i) {
            pos = new PrecisionVector(x, y, z - widthRight + 1.0 * (double)i + 0.8125);
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, 0.0, 0.3125, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, 0.0, 0.75, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, 0.0, 0.3125, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, 0.0, 0.75, 0.25, 1.0)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, 0.0, 0.625, 0.125, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
        }
        pos = new PrecisionVector(x, y, z);
        if (removal == 1) {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthRight - 1.0 + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthRight - 1.0 + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthRight - 1.0 + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthRight - 1.0 + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthRight - 1.0 + 0.8125, 0.625, 0.125, 0.1875)));
            if (remainderWidthRight > 0.5) {
                pos = new PrecisionVector(x, y, z - remainderWidthRight - 1.0 + 0.8125);
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, -0.25, 0.9375, 0.6875, -0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3125, 0.1875, 0.9375, 0.6875, 0.25, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.1875, 0.9375, 0.3125, 0.1875, 1.0)));
                lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.1875, 0.9375, 0.75, 0.1875, 1.0)));
            }
        } else {
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, -0.25, -remainderWidthRight + 0.8125, 0.3125, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, -0.25, -remainderWidthRight + 0.8125, 0.75, -0.1875, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.25, 0.1875, -remainderWidthRight + 0.8125, 0.3125, 0.25, 0.1875)));
            lightSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.6875, 0.1875, -remainderWidthRight + 0.8125, 0.75, 0.25, 0.1875)));
            darkSegments.add((Pair<PrecisionVector, AABB>)Pair.of((Object)pos, (Object)new AABB(0.3875, -0.125, -remainderWidthRight + 0.8125, 0.625, 0.125, 0.1875)));
        }
    }

    @Nullable
    private QuarryArmFrameWrapper getCurrentFrame(TileQuarry quarry) {
        if (((BlockPos)quarry.miningPos.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
            return new QuarryArmFrameWrapper(null, 0, 0, 0.0f);
        }
        if (((BlockPos)quarry.prevMiningPos.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH) || ((BlockPos)quarry.prevMiningPos.getValue()).equals(quarry.miningPos.getValue())) {
            return new QuarryArmFrameWrapper(new Location((BlockPos)quarry.miningPos.getValue()).add(-0.5, -0.5, -0.5), 0, 0, 0.0f);
        }
        if (!((Boolean)quarry.hasHead.getValue()).booleanValue() || !quarry.isMotorComplexPowered()) {
            return this.currentFrame;
        }
        int numberOfFrames = (Integer)quarry.speed.getValue();
        if (numberOfFrames == 0) {
            numberOfFrames = 1;
        }
        double deltaX = (double)(((BlockPos)quarry.miningPos.getValue()).m_123341_() - ((BlockPos)quarry.prevMiningPos.getValue()).m_123341_()) / (double)numberOfFrames;
        double deltaY = (double)(((BlockPos)quarry.miningPos.getValue()).m_123342_() - ((BlockPos)quarry.prevMiningPos.getValue()).m_123342_()) / (double)numberOfFrames;
        double deltaZ = (double)(((BlockPos)quarry.miningPos.getValue()).m_123343_() - ((BlockPos)quarry.prevMiningPos.getValue()).m_123343_()) / (double)numberOfFrames;
        if (Math.abs(deltaX) + Math.abs(deltaY) + Math.abs(deltaZ) == 0.0) {
            return new QuarryArmFrameWrapper(new Location(((BlockPos)quarry.miningPos.getValue()).m_7918_(0, -1, 0)), 0, 0, 0.0f);
        }
        float degress = 360.0f * ((float)((Integer)quarry.progressCounter.getValue()).intValue() / (float)numberOfFrames);
        int currFrame = (Integer)quarry.progressCounter.getValue() % numberOfFrames;
        int signX = (int)Math.signum(deltaX);
        int signZ = (int)Math.signum(deltaZ);
        return new QuarryArmFrameWrapper(new Location((double)((BlockPos)quarry.prevMiningPos.getValue()).m_123341_() + deltaX * (double)currFrame, (double)((BlockPos)quarry.prevMiningPos.getValue()).m_123342_() + deltaY * (double)currFrame, (double)((BlockPos)quarry.prevMiningPos.getValue()).m_123343_() + deltaZ * (double)currFrame), signX, signZ, degress);
    }
}

