/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas;

import com.google.common.collect.Lists;
import electrodynamics.common.network.type.GasNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.api.network.cable.type.IGasPipe;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;
import voltaic.registers.VoltaicCapabilities;

public abstract class GenericTileGasPipe
extends GenericRefreshingConnectTile<IGasPipe, GenericTileGasPipe, GasNetwork> {
    private final IGasHandler[] capability = new IGasHandler[6];

    public GenericTileGasPipe(BlockEntityType<?> tileEntityTypeIn, final BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
        for (final Direction dir : Direction.values()) {
            this.capability[dir.ordinal()] = new IGasHandler(){

                public boolean isGasValid(int tank, GasStack gas) {
                    return gas != null;
                }

                public int heat(int tank, int deltaTemperature, GasAction action) {
                    return -1;
                }

                public int getTanks() {
                    return 1;
                }

                public int getTankMaxTemperature(int tank) {
                    return -1;
                }

                public int getTankMaxPressure(int tank) {
                    return GenericTileGasPipe.this.getNetwork() == null ? 0 : ((GasNetwork)GenericTileGasPipe.this.getNetwork()).maxPressure;
                }

                public int getTankCapacity(int tank) {
                    return 0;
                }

                public GasStack getGasInTank(int tank) {
                    return GasStack.EMPTY;
                }

                public int fill(GasStack gas, GasAction action) {
                    if (action == GasAction.SIMULATE || GenericTileGasPipe.this.getNetwork() == null || gas.isEmpty()) {
                        return 0;
                    }
                    return ((GasNetwork)GenericTileGasPipe.this.getNetwork()).emit(gas, (ArrayList<BlockEntity>)Lists.newArrayList((Object[])new BlockEntity[]{GenericTileGasPipe.this.f_58857_.m_7702_(worldPos.m_121945_(dir))}), action == GasAction.SIMULATE).getAmount();
                }

                public GasStack drain(int maxFill, GasAction action) {
                    return GasStack.EMPTY;
                }

                public GasStack drain(GasStack gas, GasAction action) {
                    return GasStack.EMPTY;
                }

                public int bringPressureTo(int tank, int atm, GasAction action) {
                    return -1;
                }
            };
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK && side != null) {
            return LazyOptional.of(() -> this.capability[side.ordinal()]).cast();
        }
        return LazyOptional.empty();
    }

    public double getMaxTransfer() {
        return ((IGasPipe)this.getCableType()).getMaxTransfer();
    }

    public GasNetwork createInstance(Set<GasNetwork> gasNetworks) {
        return new GasNetwork(gasNetworks);
    }

    public GasNetwork createInstanceConductor(Set<GenericTileGasPipe> genericTileGasPipes) {
        return new GasNetwork((Collection<GenericTileGasPipe>)genericTileGasPipes);
    }

    public void destroyViolently() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.f_58857_.m_46961_(this.m_58899_(), false);
    }
}

