/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration;

import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosIntegration {
    @Nonnull
    public static Iterable<ItemStack> getFlatStacks(ServerPlayer player) {
        LazyOptional curios = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        if (curios.isPresent()) {
            ICuriosItemHandler peek = (ICuriosItemHandler)curios.orElseThrow(RuntimeException::new);
            return () -> new FlatIterator(peek);
        }
        return Collections.emptyList();
    }

    private static class FlatIterator
    implements Iterator<ItemStack> {
        private final Iterator<ICurioStacksHandler> mIterator;
        private IItemHandler mHandler;
        private int mIndex;

        FlatIterator(ICuriosItemHandler curios) {
            this.mIterator = curios.getCurios().values().iterator();
        }

        @Override
        public boolean hasNext() {
            this.forward();
            return this.mHandler != null && this.mIndex < this.mHandler.getSlots();
        }

        @Override
        public ItemStack next() {
            this.forward();
            return this.mHandler.getStackInSlot(this.mIndex++);
        }

        private void forward() {
            while ((this.mHandler == null || this.mIndex == this.mHandler.getSlots()) && this.mIterator.hasNext()) {
                this.mHandler = this.mIterator.next().getStacks();
                this.mIndex = 0;
            }
        }
    }
}

