/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkHooks;
import sonar.fluxnetworks.api.device.IFluxProvider;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.capability.FluxPlayer;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxStorage;

public class ItemAdminConfigurator
extends Item {
    public ItemAdminConfigurator(Item.Properties props) {
        super(props);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileFluxStorage storage;
        BlockEntity blockEntity;
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && FluxPlayer.isPlayerSuperAdmin(player) && (blockEntity = context.m_43725_().m_7702_(context.m_8083_())) instanceof TileFluxStorage && (storage = (TileFluxStorage)blockEntity).canPlayerAccess(player)) {
            storage.fillUp();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!level.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new Provider(), buf -> buf.writeBoolean(false));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static class Provider
    implements IFluxProvider {
        @Override
        public int getNetworkID() {
            assert (EffectiveSide.get().isClient());
            return ClientCache.sAdminViewingNetwork;
        }

        @Override
        public void onPlayerOpened(@Nonnull Player player) {
        }

        @Override
        public void onPlayerClosed(@Nonnull Player player) {
        }

        @Nullable
        public FluxMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new FluxMenu(containerId, inventory, this);
        }
    }
}

