/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.block.slab.FramedAdjustableDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedAdjustableDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedAdjustableDoubleSlabBlock
extends FramedAdjustableDoubleBlock {
    private FramedAdjustableDoubleSlabBlock(BlockType type, Function<BlockState, Tuple<BlockState, BlockState>> statePairBuilder, BlockEntityType.BlockEntitySupplier<FramedAdjustableDoubleBlockEntity> beSupplier) {
        super(type, state -> Direction.UP, statePairBuilder, beSupplier);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> SolidityCheck.FIRST;
            case Direction.UP -> SolidityCheck.SECOND;
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> SolidityCheck.BOTH;
        };
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> CamoGetter.FIRST;
            case Direction.UP -> CamoGetter.SECOND;
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> edge == Direction.DOWN ? CamoGetter.FIRST : (edge == Direction.UP ? CamoGetter.SECOND : CamoGetter.NONE);
        };
    }

    public static FramedAdjustableDoubleSlabBlock standard() {
        return new FramedAdjustableDoubleSlabBlock(BlockType.FRAMED_ADJ_DOUBLE_SLAB, FramedAdjustableDoubleBlock::makeStandardStatePair, (BlockEntityType.BlockEntitySupplier<FramedAdjustableDoubleBlockEntity>)((BlockEntityType.BlockEntitySupplier)FramedAdjustableDoubleBlockEntity::standard));
    }

    public static FramedAdjustableDoubleSlabBlock copycat() {
        return new FramedAdjustableDoubleSlabBlock(BlockType.FRAMED_ADJ_DOUBLE_COPYCAT_SLAB, FramedAdjustableDoubleBlock::makeCopycatStatePair, (BlockEntityType.BlockEntitySupplier<FramedAdjustableDoubleBlockEntity>)((BlockEntityType.BlockEntitySupplier)FramedAdjustableDoubleBlockEntity::copycat));
    }
}

