/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.emi;

import com.google.common.base.Stopwatch;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.client.screen.PoweredFramingSawScreen;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.emi.FramedEmiRecipeHandler;
import xfacthd.framedblocks.common.compat.emi.FramingSawEmiRecipe;
import xfacthd.framedblocks.common.compat.emi.FramingSawRecipeCategory;
import xfacthd.framedblocks.common.compat.emi.FramingSawStackProvider;
import xfacthd.framedblocks.common.compat.emi.PoweredFramingSawDragDropHandler;
import xfacthd.framedblocks.common.compat.emi.PoweredFramingSawStackProvider;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;

@EmiEntrypoint
public final class FramedEmiPlugin
implements EmiPlugin {
    public static final Lazy<EmiStack> SAW_WORKSTATION = Lazy.of(() -> EmiStack.of((ItemLike)((ItemLike)FBContent.BLOCK_FRAMING_SAW.get())));
    public static final Lazy<EmiRecipeCategory> SAW_CATEGORY = Lazy.of(() -> new FramingSawRecipeCategory((EmiRenderable)SAW_WORKSTATION.get(), (EmiRenderable)SAW_WORKSTATION.get()));

    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)SAW_CATEGORY.get());
        registry.addWorkstation((EmiRecipeCategory)SAW_CATEGORY.get(), (EmiIngredient)SAW_WORKSTATION.get());
        registry.addWorkstation((EmiRecipeCategory)SAW_CATEGORY.get(), (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)FBContent.BLOCK_POWERED_FRAMING_SAW.get())));
        registry.addRecipeHandler((MenuType)FBContent.MENU_TYPE_FRAMING_SAW.get(), new FramedEmiRecipeHandler());
        registry.addRecipeHandler((MenuType)FBContent.MENU_TYPE_POWERED_FRAMING_SAW.get(), new FramedEmiRecipeHandler());
        registry.addStackProvider(FramingSawScreen.class, (EmiStackProvider)new FramingSawStackProvider());
        registry.addStackProvider(PoweredFramingSawScreen.class, (EmiStackProvider)new PoweredFramingSawStackProvider());
        registry.addDragDropHandler(PoweredFramingSawScreen.class, (EmiDragDropHandler)new PoweredFramingSawDragDropHandler());
        FramedEmiPlugin.registerRecipes(registry);
    }

    private static void registerRecipes(EmiRegistry registry) {
        FramedBlocks.LOGGER.debug("Registering framing saw recipes to EMI...");
        Stopwatch watch = Stopwatch.createStarted();
        int[] recipeCount = new int[1];
        FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
        Set<Item> inputItems = ClientConfig.showAllRecipePermutationsInEmi ? cache.getKnownItems() : Set.of(((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_5456_());
        SimpleContainer dummyContainer = new SimpleContainer(1);
        cache.getRecipes().forEach(arg_0 -> FramedEmiPlugin.lambda$registerRecipes$3(inputItems, (Container)dummyContainer, registry, recipeCount, arg_0));
        watch.stop();
        FramedBlocks.LOGGER.debug("Registered {} framing saw recipes to EMI in {}", (Object)recipeCount[0], (Object)watch);
    }

    static int compareRecipes(EmiRecipe recipeOne, EmiRecipe recipeTwo) {
        FramingSawEmiRecipe sawRecipeTwo;
        ItemStack resultTwo;
        FramingSawEmiRecipe sawRecipeOne;
        ItemStack resultOne;
        if (!(recipeOne instanceof FramingSawEmiRecipe) || (resultOne = (sawRecipeOne = (FramingSawEmiRecipe)recipeOne).getOutputInternal()).m_41619_()) {
            return 1;
        }
        if (!(recipeTwo instanceof FramingSawEmiRecipe) || (resultTwo = (sawRecipeTwo = (FramingSawEmiRecipe)recipeTwo).getOutputInternal()).m_41619_()) {
            return -1;
        }
        return FramingSawRecipeCache.sortRecipes(resultOne, resultTwo, sawRecipeOne.getResultType(), sawRecipeTwo.getResultType());
    }

    private static /* synthetic */ void lambda$registerRecipes$3(Set inputItems, Container dummyContainer, EmiRegistry registry, int[] recipeCount, FramingSawRecipe recipe) {
        for (Item item : inputItems) {
            if (recipe.getResult().m_150930_(item)) continue;
            ItemStack inputStack = new ItemStack((ItemLike)item);
            dummyContainer.m_6836_(0, inputStack);
            FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(dummyContainer, true);
            int outputCount = calc.getOutputCount();
            EmiStack input = EmiStack.of((ItemStack)inputStack, (long)calc.getInputCount());
            List<EmiIngredient> additives = recipe.getAdditives().stream().map(additive -> {
                int addCount = additive.count() * (outputCount / recipe.getResult().m_41613_());
                return EmiIngredient.of((Ingredient)additive.ingredient(), (long)addCount);
            }).toList();
            EmiStack output = EmiStack.of((ItemStack)recipe.getResult(), (long)outputCount);
            registry.addRecipe((EmiRecipe)FramingSawEmiRecipe.make(recipe, input, additives, output));
            recipeCount[0] = recipeCount[0] + 1;
        }
    }
}

