/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.door;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class GateShapes {
    private static final ShapeCache<Direction> SHAPES = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });

    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
                boolean rightHinge = state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.RIGHT;
                dir = rightHinge ? dir.m_122428_() : dir.m_122427_();
            }
            builder.put((Object)state, (Object)SHAPES.get(dir));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private GateShapes() {
    }
}

