/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element.button;

import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.SupportsColorMap;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorLogicButton<TYPE extends Enum<TYPE>>
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismGenerators.rl(MekanismUtils.ResourceType.GUI_BUTTON.getPrefix() + "reactor_logic.png");
    @NotNull
    private final IReactorLogic<TYPE> tile;
    private final int typeOffset;
    private final Supplier<@Nullable TYPE> modeSupplier;

    public ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @NotNull IReactorLogic<TYPE> tile, IntSupplier indexSupplier, Supplier<TYPE[]> modeList, Consumer<TYPE> onPress) {
        this(gui, x, y, index, tile, onPress, () -> {
            int i = indexSupplier.getAsInt() + index;
            Enum[] modes = (Enum[])modeList.get();
            return i >= 0 && i < modes.length ? modes[i] : null;
        });
    }

    private ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @NotNull IReactorLogic<TYPE> tile, Consumer<TYPE> onPress, Supplier<@Nullable TYPE> modeSupplier) {
        super(gui, x, y, 128, 22, (Component)Component.m_237119_(), () -> {
            Enum mode = (Enum)modeSupplier.get();
            if (mode != null) {
                onPress.accept(mode);
            }
        }, (onHover, guiGraphics, mouseX, mouseY) -> {
            Enum mode = (Enum)modeSupplier.get();
            if (mode != null) {
                gui.displayTooltips(guiGraphics, mouseX, mouseY, new Component[]{((IReactorLogicMode)((Object)mode)).getDescription()});
            }
        });
        this.typeOffset = 22 * index;
        this.modeSupplier = modeSupplier;
        this.tile = tile;
    }

    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            MekanismRenderer.color((GuiGraphics)guiGraphics, (SupportsColorMap)((IReactorLogicMode)((Object)mode)).getColor());
            guiGraphics.m_280163_(TEXTURE, this.getButtonX(), this.getButtonY(), 0.0f, mode == this.tile.getMode() ? 22.0f : 0.0f, this.getButtonWidth(), this.getButtonHeight(), 128, 44);
            MekanismRenderer.resetColor((GuiGraphics)guiGraphics);
        }
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            this.gui().renderItem(guiGraphics, ((IReactorLogicMode)((Object)mode)).getRenderStack(), 20, 35 + this.typeOffset);
            this.drawString(guiGraphics, (Component)TextComponentUtil.build((Object[])new Object[]{EnumColor.WHITE, mode}), 39, 34 + this.typeOffset, this.titleTextColor());
            super.renderForeground(guiGraphics, mouseX, mouseY);
        }
    }
}

