/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.item;

import gisellevonbingen.mmp.common.config.MMPConfigs;
import gisellevonbingen.mmp.common.item.ItemStatedMaterial;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import gisellevonbingen.mmp.common.util.LauncherUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class MMPItems {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("moremekanismprocessing");
    public static final Map<MaterialType, Map<MaterialState, ItemRegistryObject<Item>>> PROCESSING_ITEMS = new HashMap<MaterialType, Map<MaterialState, ItemRegistryObject<Item>>>();

    public static ResourceLocation getProcessingItemName(MaterialType materialType, MaterialState materialState) {
        ResourceLocation presetName = materialType.getPresetItem(materialState);
        if (presetName != null) {
            return presetName;
        }
        Map<MaterialState, ItemRegistryObject<Item>> map = PROCESSING_ITEMS.get((Object)materialType);
        if (map == null) {
            return null;
        }
        ItemRegistryObject<Item> registryObject = map.get((Object)materialState);
        return registryObject != null ? registryObject.getRegistryName() : null;
    }

    public static Item getProcessingItem(MaterialType materialType, MaterialState materialState) {
        ResourceLocation presetName = materialType.getPresetItem(materialState);
        if (presetName != null) {
            return (Item)ForgeRegistries.ITEMS.getValue(presetName);
        }
        Map<MaterialState, ItemRegistryObject<Item>> map = PROCESSING_ITEMS.get((Object)materialType);
        if (map == null) {
            return null;
        }
        ItemRegistryObject<Item> registryObject = map.get((Object)materialState);
        return registryObject != null ? (ItemStatedMaterial)((Object)registryObject.get()) : null;
    }

    public static List<ItemStatedMaterial> getProcessingItems(MaterialState materialState) {
        ArrayList<ItemStatedMaterial> list = new ArrayList<ItemStatedMaterial>();
        for (Map.Entry<MaterialType, Map<MaterialState, ItemRegistryObject<Item>>> entry : PROCESSING_ITEMS.entrySet()) {
            ItemRegistryObject<Item> registryObject = entry.getValue().get((Object)materialState);
            if (registryObject == null) continue;
            ItemStatedMaterial item = (ItemStatedMaterial)((Object)registryObject.get());
            list.add(item);
        }
        return list;
    }

    public static int getProcessingLevel(MaterialState materialState) {
        if (materialState == MaterialState.CRYSTAL) {
            return 5;
        }
        if (materialState == MaterialState.SHARD) {
            return 4;
        }
        if (materialState == MaterialState.DIRTY_DUST || materialState == MaterialState.CLUMP) {
            return 3;
        }
        return 2;
    }

    public static boolean testProcessingLevel(MaterialType materialType, MaterialState materialState) {
        int requireLevel;
        if (LauncherUtil.isRunDevData()) {
            return true;
        }
        ForgeConfigSpec.ConfigValue<Integer> configValue = MMPConfigs.COMMON.processingLevels.get((Object)materialType);
        if (configValue == null) {
            return true;
        }
        int processingLevel = (Integer)configValue.get();
        return processingLevel >= (requireLevel = MMPItems.getProcessingLevel(materialState));
    }

    public static void registerOreType(ItemDeferredRegister registry, MaterialType materialType) {
        HashMap<MaterialState, ItemRegistryObject> map2 = new HashMap<MaterialState, ItemRegistryObject>();
        PROCESSING_ITEMS.put(materialType, map2);
        for (MaterialState materialState : materialType.getResultShape().getProcessableStates()) {
            ResourceLocation presetName = materialType.getPresetItem(materialState);
            if (presetName != null || !materialState.hasOwnItem()) continue;
            ItemRegistryObject registryObject = registry.register(materialState.getItemNamePath(materialType), () -> new ItemStatedMaterial(materialType, materialState));
            map2.put(materialState, registryObject);
        }
    }

    static {
        for (MaterialType materialType : MaterialType.values()) {
            MMPItems.registerOreType(ITEMS, materialType);
        }
    }
}

