/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.sound;

import java.util.HashMap;
import lehjr.numina.client.sound.MovingSoundPlayer;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.config.NuminaSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Musique {
    private static HashMap<String, MovingSoundPlayer> soundMap = new HashMap();

    public static SoundManager mcsound() {
        return Minecraft.m_91087_().m_91106_();
    }

    public static void playClientSound(SoundEvent soundEvt, float volumeIn) {
        if (NuminaSettings.useSounds()) {
            Musique.mcsound().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvt, (float)volumeIn));
        }
    }

    public static String makeSoundString(Player player, SoundEvent soundEvt) {
        return Musique.makeSoundString(player, soundEvt.m_11660_());
    }

    public static String makeSoundString(Player player, ResourceLocation soundname) {
        return player.m_20148_().toString() + soundname;
    }

    public static void playerSound(Player player, SoundEvent soundEvt, SoundSource categoryIn, float volume, Float pitch, Boolean continuous) {
        pitch = Float.valueOf(pitch != null ? pitch.floatValue() : 1.0f);
        continuous = continuous != null ? continuous : true;
        if (NuminaSettings.useSounds() && soundEvt != null) {
            String soundID = Musique.makeSoundString(player, soundEvt);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null && (sound.m_7801_() || !sound.m_7775_())) {
                Musique.stopPlayerSound(player, soundEvt);
                sound = null;
            }
            if (sound != null) {
                sound.updateVolume(volume).updatePitch(pitch.floatValue()).updateRepeat(continuous);
            } else {
                NuminaLogger.logDebug("New sound: " + soundEvt.m_11660_());
                MovingSoundPlayer newsound = new MovingSoundPlayer(soundEvt, categoryIn, player, volume * 2.0f, pitch.floatValue(), continuous);
                Musique.mcsound().m_120367_((SoundInstance)newsound);
                soundMap.put(soundID, newsound);
            }
        }
    }

    public static void stopPlayerSound(Player player, SoundEvent soundEvt) {
        if (NuminaSettings.useSounds()) {
            String soundID = Musique.makeSoundString(player, soundEvt);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null) {
                sound.stopPlaying();
                Musique.mcsound().m_120399_((SoundInstance)sound);
            }
            soundMap.remove(soundID);
        }
    }
}

