/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.heat;

import lehjr.numina.common.capabilities.heat.IHeatStorage;
import net.minecraft.nbt.DoubleTag;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class HeatStorage
implements IHeatStorage,
INBTSerializable<DoubleTag> {
    protected double heat;
    protected double capacity;
    protected double maxReceive;
    protected double maxExtract;

    public HeatStorage(double capacity) {
        this(capacity, capacity, capacity, 0.0);
    }

    public HeatStorage(double capacity, double maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0.0);
    }

    public HeatStorage(double capacity, double maxReceive, double maxExtract) {
        this(capacity, maxReceive, maxExtract, 0.0);
    }

    public HeatStorage(double capacity, double maxReceive, double maxExtract, double heat) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.heat = heat;
    }

    @Override
    public double receiveHeat(double maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0.0;
        }
        double heatReceived = Math.min(this.capacity - this.heat, Math.min(this.maxReceive, maxReceive));
        if (!simulate && heatReceived != 0.0) {
            this.heat += heatReceived;
            this.onValueChanged();
        }
        return heatReceived;
    }

    @Override
    public double extractHeat(double maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0.0;
        }
        double heatExtracted = Math.min(this.heat, maxExtract);
        if (!simulate && heatExtracted != 0.0) {
            this.heat -= heatExtracted;
            this.onValueChanged();
        }
        return heatExtracted;
    }

    @Override
    public double getHeatStored() {
        return this.heat;
    }

    @Override
    public double getMaxHeatStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.heat > 0.0;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0.0;
    }

    @Override
    public void setHeatCapacity(double maxHeat) {
        this.capacity = maxHeat;
    }

    public DoubleTag serializeNBT() {
        return DoubleTag.m_128500_((double)this.heat);
    }

    public void deserializeNBT(DoubleTag nbt) {
        this.heat = nbt.m_7061_();
    }
}

