/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.heat;

import com.google.common.util.concurrent.AtomicDouble;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.constants.NuminaConstants;
import lehjr.numina.common.item.ItemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class HeatUtils {
    static final ResourceKey<DamageType> OVERHEAT_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)NuminaConstants.OVERHEAT_DAMAGE_REGANAME);

    public static double getPlayerHeat(LivingEntity entity) {
        double heat = 0.0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            heat += HeatUtils.getItemHeat(ItemUtils.getItemFromEntitySlot(entity, slot));
        }
        return heat;
    }

    public static double getPlayerMaxHeat(LivingEntity entity) {
        AtomicDouble maxHeat = new AtomicDouble(0.0);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = ItemUtils.getItemFromEntitySlot(entity, slot);
            if (!slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR) && (!slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || itemStack.m_41720_() instanceof ArmorItem)) continue;
            itemStack.getCapability(NuminaCapabilities.HEAT).ifPresent(heat -> maxHeat.getAndAdd(heat.getMaxHeatStored()));
        }
        return maxHeat.get();
    }

    public static double coolPlayer(LivingEntity entity, double coolJoules) {
        if (entity.m_9236_().f_46443_) {
            return 0.0;
        }
        double coolingLeft = coolJoules;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (entity.m_6117_() && player.m_150109_().m_36056_() == stack) continue;
                if (coolingLeft > 0.0) {
                    coolingLeft -= HeatUtils.coolItem(stack, coolingLeft);
                    continue;
                }
                break;
            }
        } else {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (coolingLeft > 0.0) {
                    coolingLeft -= HeatUtils.coolItem(ItemUtils.getItemFromEntitySlot(entity, slot), coolingLeft);
                    continue;
                }
                break;
            }
        }
        return coolJoules - coolingLeft;
    }

    public static double heatPlayer(LivingEntity entity, double heatJoules) {
        if (entity.m_9236_().f_46443_) {
            return 0.0;
        }
        double heatLeftToGive = heatJoules;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (heatLeftToGive == 0.0) break;
            heatLeftToGive -= HeatUtils.heatItem(ItemUtils.getItemFromEntitySlot(entity, slot), heatLeftToGive);
        }
        return heatLeftToGive;
    }

    public static void heatEntity(LivingAttackEvent event) {
        if (event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
            double heatLeftToGive;
            double originalHeatToGive = heatLeftToGive = (double)Math.round(event.getAmount());
            LivingEntity entity = event.getEntity();
            boolean allPresent = true;
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.getCapability(NuminaCapabilities.HEAT).isPresent()) continue;
                allPresent = false;
                break;
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (heatLeftToGive == 0.0) break;
                double finalHeatLeftToGive = heatLeftToGive;
                heatLeftToGive -= ItemUtils.getItemFromEntitySlot(entity, slot).getCapability(NuminaCapabilities.HEAT).map(heat -> heat.receiveHeat(finalHeatLeftToGive, false)).orElse(0.0).doubleValue();
            }
            if (heatLeftToGive < originalHeatToGive) {
                if (allPresent) {
                    event.setCanceled(true);
                }
                if (heatLeftToGive > 0.0) {
                    entity.m_6469_(new OverheatDamage(entity.m_9236_().m_9598_()).overheat(), (float)heatLeftToGive);
                }
            }
        }
    }

    public static double getItemMaxHeat(@Nonnull ItemStack stack) {
        return stack.getCapability(NuminaCapabilities.HEAT).map(h -> h.getMaxHeatStored()).orElse(0.0);
    }

    public static double getItemHeat(@Nonnull ItemStack stack) {
        return stack.getCapability(NuminaCapabilities.HEAT).map(h -> h.getHeatStored()).orElse(0.0);
    }

    public static double heatItem(@Nonnull ItemStack stack, double value) {
        return stack.getCapability(NuminaCapabilities.HEAT, null).map(h -> h.receiveHeat(value, false)).orElse(0.0);
    }

    public static double coolItem(@Nonnull ItemStack stack, double value) {
        return stack.getCapability(NuminaCapabilities.HEAT, null).map(h -> h.extractHeat(value, false)).orElse(0.0);
    }

    public static class OverheatDamage {
        private final DamageSource overheat;
        private final Registry<DamageType> damageTypes;

        public OverheatDamage(RegistryAccess registry) {
            this.damageTypes = registry.m_175515_(Registries.f_268580_);
            this.overheat = this.source();
        }

        private DamageSource source() {
            return new DamageSource((Holder)this.damageTypes.m_246971_(OVERHEAT_DAMAGE));
        }

        public DamageSource overheat() {
            return this.overheat;
        }
    }
}

