/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.recipe;

import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.recipe.RecipeSerializersRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleInstallationRecipe
extends CustomRecipe {
    public ModuleInstallationRecipe(ResourceLocation idIn, CraftingBookCategory categoryIn) {
        super(idIn, categoryIn);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack modularItem = ItemStack.f_41583_;
        NonNullList modules = NonNullList.m_122779_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isModularItem(stack)) {
                if (!modularItem.m_41619_()) {
                    return false;
                }
                modularItem = stack;
                continue;
            }
            if (this.isModule(stack)) {
                if (this.listContains(stack, (NonNullList<ItemStack>)modules)) {
                    return false;
                }
                modules.add((Object)stack);
                continue;
            }
            return false;
        }
        if (modularItem.m_41619_() || modules.isEmpty()) {
            return false;
        }
        return this.getModularItemCap(modularItem).map(iModularItem -> {
            for (ItemStack module : modules) {
                if (!iModularItem.isModuleValid(module)) {
                    return false;
                }
                if (iModularItem.isModuleInstalled(module)) {
                    return false;
                }
                Optional<IPowerModule> pm = this.getPowerModuleCap(module);
                if (!pm.isPresent()) continue;
                ModuleCategory category = this.getCategory(pm);
                int tier = this.getTier(pm);
                Pair<Integer, Integer> range = iModularItem.getRangeForCategory(category);
                if (range != null) {
                    for (int i = ((Integer)range.getKey()).intValue(); i < (Integer)range.getValue(); ++i) {
                        ItemStack tesStack = iModularItem.getStackInSlot(i);
                        if (tesStack.m_41619_()) {
                            return true;
                        }
                        if (tier >= -1) continue;
                        Optional<IPowerModule> pmcapTest = this.getPowerModuleCap(tesStack);
                        ModuleCategory testCategory = this.getCategory(pmcapTest);
                        int testTier = this.getTier(pmcapTest);
                        if (!testCategory.equals((Object)category)) continue;
                        return tier > testTier;
                    }
                    continue;
                }
                boolean canInstall = false;
                for (int i = 0; i < iModularItem.getSlots(); ++i) {
                    if (!iModularItem.isItemValid(i, module) || !iModularItem.getStackInSlot(i).m_41619_()) continue;
                    canInstall = true;
                    break;
                }
                if (canInstall) continue;
                return false;
            }
            return true;
        }).orElse(false) != false && !modularItem.m_41619_() && !modules.isEmpty();
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack modularItem = ItemStack.f_41583_;
        NonNullList modules = NonNullList.m_122779_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isModularItem(stack) && modularItem.m_41619_()) {
                modularItem = stack;
                continue;
            }
            if (!this.isModule(stack)) continue;
            modules.add((Object)stack);
        }
        ItemStack copy = modularItem.m_41777_();
        Optional<IModularItem> modularItemCap = this.getModularItemCap(copy);
        modularItemCap.ifPresent(iModularItem -> modules.forEach(module -> {
            for (int i = 0; i < iModularItem.getSlots(); ++i) {
                if (!iModularItem.isItemValid(i, (ItemStack)module)) continue;
                iModularItem.insertItem(i, (ItemStack)module, false);
                break;
            }
        }));
        return copy;
    }

    boolean listContains(@Nonnull ItemStack test, NonNullList<ItemStack> stackList) {
        if (stackList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < stackList.size(); ++i) {
            if (!ItemStack.m_150942_((ItemStack)test, (ItemStack)((ItemStack)stackList.get(i)))) continue;
            return true;
        }
        return false;
    }

    Optional<IPowerModule> getPowerModuleCap(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(NuminaCapabilities.POWER_MODULE).filter(IPowerModule.class::isInstance).map(IPowerModule.class::cast);
    }

    ModuleCategory getCategory(Optional<IPowerModule> pmcap) {
        return pmcap.map(IPowerModule::getCategory).orElse(ModuleCategory.NONE);
    }

    int getTier(Optional<IPowerModule> pmcap) {
        return pmcap.map(IPowerModule::getTier).orElse(-1);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean isModule(@Nonnull ItemStack itemStack) {
        return this.getPowerModuleCap(itemStack).isPresent();
    }

    Optional<IModularItem> getModularItemCap(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast);
    }

    public boolean isModularItem(ItemStack itemStack) {
        return this.getModularItemCap(itemStack).isPresent();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.ATTACHMENT.get();
    }
}

