/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import gigaherz.packingtape.ConfigValues;
import gigaherz.packingtape.PackingTapeMod;
import gigaherz.packingtape.tape.PackagedBlock;
import gigaherz.packingtape.tape.PackagedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;

public class TapeItem
extends Item {
    public TapeItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxDamage(ItemStack stack) {
        return ConfigValues.tapeRollUses;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxStackSize(ItemStack stack) {
        return stack.m_41773_() == 0 ? super.getMaxStackSize(stack) : 1;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player playerIn = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (stack.m_41613_() <= 0) {
            return InteractionResult.PASS;
        }
        BlockState state = world.m_8055_(pos);
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return InteractionResult.PASS;
        }
        if (!playerIn.m_150110_().f_35937_ && ConfigValues.consumesPaper && !this.hasPaper(playerIn)) {
            MutableComponent textComponent = Component.m_237115_((String)"text.packingtape.tape.requires_paper");
            playerIn.m_5661_((Component)textComponent, true);
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ConfigValues.isBlockEntityBlocked(te)) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof ChestBlock && state.m_61138_((Property)ChestBlock.f_51479_) && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            state = (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE);
        }
        CompoundTag tag = te.m_187482_();
        world.m_46747_(pos);
        world.m_46597_(pos, ((PackagedBlock)((Object)PackingTapeMod.PACKAGED_BLOCK.get())).m_49966_());
        BlockEntity te2 = world.m_7702_(pos);
        if (te2 instanceof PackagedBlockEntity) {
            PackagedBlockEntity packaged = (PackagedBlockEntity)te2;
            packaged.setContents(state, tag);
        }
        if (!playerIn.m_150110_().f_35937_) {
            if (ConfigValues.consumesPaper) {
                this.usePaper(playerIn);
            }
            if (stack.m_41613_() > 1) {
                ItemStack split = stack.m_41777_();
                split.m_41764_(1);
                split.m_41721_(split.m_41773_() + 1);
                if (stack.m_41773_() < stack.m_41776_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)split);
                }
                stack.m_41774_(1);
            } else {
                stack.m_41721_(stack.m_41773_() + 1);
                if (stack.m_41773_() >= stack.m_41776_()) {
                    stack.m_41774_(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean hasPaper(Player playerIn) {
        ItemStack stack = playerIn.m_6844_(EquipmentSlot.OFFHAND);
        if (stack.m_41720_() == Items.f_42516_) {
            return true;
        }
        Inventory inv = playerIn.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41720_() != Items.f_42516_) continue;
            return true;
        }
        return false;
    }

    private void usePaper(Player playerIn) {
        ItemStack stack = playerIn.m_6844_(EquipmentSlot.OFFHAND);
        if (stack.m_41720_() == Items.f_42516_) {
            stack.m_41769_(-1);
            if (stack.m_41613_() <= 0) {
                playerIn.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        }
        Inventory inv = playerIn.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41720_() != Items.f_42516_) continue;
            stack.m_41769_(-1);
            if (stack.m_41613_() <= 0) {
                inv.m_6836_(i, ItemStack.f_41583_);
            }
            return;
        }
    }
}

