/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.compat.tacz;

import com.scarasol.pillagers_gun.config.CommonConfig;
import com.scarasol.pillagers_gun.entity.goal.GunAttackGoal;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class TaczGunAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private GunState gunState = GunState.UNCHARGED;
    private final double speedModifier;
    private int seeTime;
    private int attackDelay;
    private double attackCount;
    private int ammoCount;
    private boolean away;
    private boolean stopped;

    public TaczGunAttackGoal(T mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isHoldingGun() && (this.isValidTarget() || !this.hasAmmo() && this.canReload() || GunAttackGoal.isStunned(this.mob));
    }

    private boolean isHoldingGun() {
        return this.getGun() != null;
    }

    private boolean canReload() {
        if (!((Boolean)CommonConfig.TACZ_GUNNERS_NEED_AMMO.get()).booleanValue()) {
            return true;
        }
        IGun iGun = this.getGun();
        if (iGun instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)iGun;
            ItemStack itemStack = this.mob.m_21120_(InteractionHand.MAIN_HAND);
            if (gunItem.useDummyAmmo(itemStack) && gunItem.getDummyAmmoAmount(itemStack) == 0) {
                itemStack.m_41784_().m_128473_("DummyAmmo");
            }
            return gunItem.canReload(this.mob, itemStack);
        }
        return false;
    }

    private IGun getGun() {
        return IGun.getIGunOrNull((ItemStack)this.mob.m_21120_(InteractionHand.MAIN_HAND));
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean m_8045_() {
        return this.isHoldingGun() && (this.isValidTarget() || !this.hasAmmo() && this.canReload() || GunAttackGoal.isStunned(this.mob));
    }

    private boolean hasAmmo() {
        return this.getAmmoCount(this.mob.m_21120_(InteractionHand.MAIN_HAND)) != 0;
    }

    private boolean isRightAngle() {
        if (GunAttackGoal.isStunned(this.mob)) {
            return true;
        }
        if (this.isValidTarget()) {
            LivingEntity target = this.mob.m_5448_();
            return this.vectorDegreeCalculate(this.mob.m_20252_(1.0f), target.m_146892_().m_82546_(this.mob.m_146892_())) < 10.0 + Math.max(0.0, 64.0 - this.mob.m_20280_((Entity)target));
        }
        return false;
    }

    private int getAmmoCount(ItemStack itemStack) {
        GunData gunData;
        IGun iGun = IGun.getIGunOrNull((ItemStack)itemStack);
        if (iGun != null && (gunData = (GunData)TimelessAPI.getCommonGunIndex((ResourceLocation)iGun.getGunId(itemStack)).map(CommonGunIndex::getGunData).orElse(null)) != null) {
            return iGun.useInventoryAmmo(itemStack) ? -1 : iGun.getCurrentAmmoCount(itemStack) + (iGun.hasBulletInBarrel(itemStack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        }
        return 0;
    }

    public void m_8056_() {
        this.gunState = GunState.UNCHARGED;
        IGunOperator.fromLivingEntity(this.mob).draw(() -> this.mob.m_21205_());
        IGunOperator.fromLivingEntity(this.mob).getDataHolder().drawTimestamp = System.currentTimeMillis() - 10000L;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        this.attackDelay = 0;
        this.attackCount = 0.0;
        this.mob.m_21573_().m_26573_();
        if (this.isHoldingGun()) {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.mob);
            gunOperator.cancelReload();
            gunOperator.aim(false);
            GunData gunData = TimelessAPI.getCommonGunIndex((ResourceLocation)this.getGun().getGunId(this.mob.m_21205_())).map(CommonGunIndex::getGunData).orElse(null);
            if (gunData != null && gunData.getBolt() == Bolt.MANUAL_ACTION) {
                gunOperator.bolt();
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        block28: {
            IGun iGun;
            GunData gunData;
            IGunOperator gunOperator;
            boolean isStunned;
            ItemStack itemStack;
            boolean flag;
            LivingEntity livingentity;
            block30: {
                Object vec3;
                block29: {
                    livingentity = this.mob.m_5448_();
                    boolean flag2 = false;
                    flag = false;
                    double attackRadius = this.mob.m_21133_(Attributes.f_22277_);
                    itemStack = this.mob.m_21205_();
                    isStunned = GunAttackGoal.isStunned(this.mob);
                    if (this.isValidTarget()) {
                        this.mob.m_21561_(true);
                        double d0 = livingentity.m_20182_().m_82546_(this.mob.m_20182_()).m_82553_();
                        boolean bl = flag = this.mob.m_21574_().m_148306_((Entity)livingentity) && !isStunned;
                        this.seeTime = flag ? ++this.seeTime : 0;
                        if (!isStunned) {
                            if (d0 <= attackRadius && this.seeTime > 5) {
                                if (!this.hasAmmo()) {
                                    this.stopped = false;
                                    if (d0 < attackRadius / 2.0) {
                                        this.away = true;
                                        vec3 = this.mob.m_20182_().m_82549_(this.mob.m_20182_().m_82492_(livingentity.m_20182_().f_82479_, this.mob.m_20182_().f_82480_, livingentity.m_20182_().f_82481_).m_82541_().m_82490_(attackRadius / 2.0));
                                        this.mob.m_21573_().m_26519_(((Vec3)vec3).f_82479_, ((Vec3)vec3).f_82480_, ((Vec3)vec3).f_82481_, this.speedModifier);
                                    }
                                    if (this.away && d0 > attackRadius * 2.0 / 3.0) {
                                        this.mob.m_21573_().m_26573_();
                                        this.away = false;
                                    } else if (!this.away && d0 < attackRadius * 2.0 / 3.0) {
                                        this.mob.m_21573_().m_26573_();
                                    }
                                } else if (this.hasAmmo() && !this.stopped) {
                                    this.mob.m_21573_().m_26573_();
                                    this.stopped = true;
                                }
                            } else {
                                this.stopped = false;
                                this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                            }
                            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                        }
                        boolean bl2 = flag2 = (d0 > attackRadius || this.seeTime < 5) && this.attackDelay == 0;
                    }
                    if (!this.isHoldingGun()) break block28;
                    gunOperator = IGunOperator.fromLivingEntity(this.mob);
                    if (this.isValidTarget() && this.canMeleeAttack(gunOperator, livingentity)) {
                        gunOperator.melee();
                        return;
                    }
                    if (this.getGun().isOverheatLocked(itemStack)) {
                        this.gunState = GunState.UNCHARGED;
                        return;
                    }
                    if (this.gunState == GunState.UNCHARGED && this.hasAmmo()) {
                        this.gunState = GunState.CHARGED;
                        this.ammoCount = this.getAmmoCount(itemStack);
                    } else if (this.gunState == GunState.CHARGED && !this.hasAmmo()) {
                        this.gunState = GunState.UNCHARGED;
                    }
                    if (this.gunState != GunState.UNCHARGED) break block29;
                    if (flag2 || !this.canReload() || isStunned) break block28;
                    gunOperator.reload();
                    this.gunState = GunState.CHARGING;
                    vec3 = this.mob;
                    if (!(vec3 instanceof CrossbowAttackMob)) break block28;
                    CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)vec3;
                    crossbowAttackMob.m_6136_(true);
                    break block28;
                }
                if (this.gunState != GunState.CHARGING) break block30;
                if (!this.isHoldingGun()) {
                    this.gunState = GunState.UNCHARGED;
                }
                if (gunOperator.getDataHolder().reloadStateType.isReloading()) break block28;
                if (this.hasAmmo()) {
                    this.gunState = GunState.CHARGED;
                    this.attackDelay = 10 + this.mob.m_217043_().m_188503_(20);
                    this.ammoCount = this.getAmmoCount(itemStack);
                } else {
                    this.gunState = GunState.UNCHARGED;
                }
                vec3 = this.mob;
                if (!(vec3 instanceof CrossbowAttackMob)) break block28;
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)vec3;
                crossbowAttackMob.m_6136_(false);
                break block28;
            }
            if (this.gunState == GunState.CHARGED) {
                if (--this.attackDelay <= 0) {
                    gunOperator.aim(true);
                    this.gunState = GunState.READY_TO_ATTACK;
                    this.attackDelay = 0;
                }
            } else if (this.gunState == GunState.READY_TO_ATTACK && (flag || isStunned) && this.isRightAngle() && (gunData = (GunData)TimelessAPI.getCommonGunIndex((ResourceLocation)(iGun = this.getGun()).getGunId(itemStack)).map(CommonGunIndex::getGunData).orElse(null)) != null) {
                this.attackCount += iGun.getFireMode(itemStack) == FireMode.AUTO ? (double)iGun.getRPM(itemStack) / 1200.0 : (double)iGun.getRPM(itemStack) / (isStunned ? 2400.0 : Math.max(1200.0 * (double)(livingentity.m_20270_(this.mob) / 8.0f), 2400.0));
                while (this.attackCount >= 1.0) {
                    if (this.isHoldingGun()) {
                        gunOperator.shoot(() -> this.mob.m_146909_(), () -> this.mob.m_6080_());
                        if (gunData.getBolt() == Bolt.MANUAL_ACTION) {
                            gunOperator.bolt();
                        }
                        if (this.ammoCount > 0) {
                            --this.ammoCount;
                        }
                        if (this.ammoCount == 0) {
                            gunOperator.aim(false);
                            this.attackCount = 0.0;
                            this.gunState = GunState.UNCHARGED;
                            break;
                        }
                    }
                    this.attackCount -= 1.0;
                }
            }
        }
    }

    private boolean canRun() {
        return this.gunState != GunState.CHARGING;
    }

    public double vectorDegreeCalculate(Vec3 vec1, Vec3 vec2) {
        double cos = vec1.m_82526_(vec2) / vec1.m_82553_() / vec2.m_82553_();
        return Math.toDegrees(Math.acos(cos));
    }

    public boolean canMeleeAttack(IGunOperator gunOperator, LivingEntity target) {
        return System.currentTimeMillis() - gunOperator.getDataHolder().meleeTimestamp > 3000L && this.isValidTarget() && this.getAttackReachSqr(target) >= this.mob.m_20280_((Entity)target);
    }

    public double getAttackReachSqr(LivingEntity target) {
        return (double)this.mob.m_20205_() * 2.0 * (double)this.mob.m_20205_() * 2.0 + (double)target.m_20205_();
    }

    static enum GunState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

