/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.CrateBlockEntity;
import org.violetmoon.quark.addons.oddities.capability.CrateItemHandler;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class CrateBlock
extends ZetaBlock
implements EntityBlock {
    public static final BooleanProperty PROPERTY_OPEN = BlockStateProperties.f_61446_;

    public CrateBlock(@Nullable ZetaModule module) {
        super("crate", module, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PROPERTY_OPEN, (Comparable)Boolean.valueOf(false)));
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_256791_, (ItemLike)Blocks.f_50618_, false);
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)be;
            CrateItemHandler crateHandler = crate.itemHandler();
            return (int)(Math.floor((double)crateHandler.displayTotal * 14.0 / (double)crateHandler.getSlots()) + (double)(crateHandler.displayTotal > 0 ? 1 : 0));
        }
        return 0;
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        MenuProvider provider;
        BlockEntity be = level.m_7702_(pos);
        return be instanceof MenuProvider ? (provider = (MenuProvider)be) : null;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = worldIn.m_7702_(pos);
        if (be instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)be;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)crate, (BlockPos)pos);
            }
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)tileentity;
            crate.m_58638_(stack.m_41786_());
        }
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof CrateBlockEntity) {
            ((CrateBlockEntity)tileentity).crateTick();
        }
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (!state.m_60713_(newState.m_60734_()) && (tileentity = worldIn.m_7702_(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)tileentity;
            crate.spillTheTea();
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_OPEN});
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrateBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return CrateBlock.createTickerHelper(type, CrateModule.blockEntityType, CrateBlockEntity::tick);
    }
}

