/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.client.render.item.TowerShieldBEWLR;
import com.oblivioussp.spartanshields.config.Config;
import com.oblivioussp.spartanshields.init.ModEnchantments;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ShieldBaseItem
extends ShieldItem {
    protected final boolean isTowerShield;
    protected int maxDurability;

    public ShieldBaseItem(int defaultDurability, boolean isTowerShieldIn, Item.Properties prop) {
        super(prop.m_41503_(isTowerShieldIn ? Mth.m_14143_((float)((float)defaultDurability * 1.25f)) : defaultDurability));
        this.maxDurability = defaultDurability;
        this.isTowerShield = isTowerShieldIn;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ShieldBaseItem.this.isTowerShield ? TowerShieldBEWLR.INSTANCE : super.getCustomRenderer();
            }
        });
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDurability;
    }

    public void setMaxDamage(int maxDamage) {
        this.maxDurability = this.isTowerShield ? Mth.m_14107_((double)((double)maxDamage * (Double)Config.INSTANCE.towerShieldDurabilityMultiplier.get())) : maxDamage;
    }

    public void m_7373_(ItemStack stackIn, Level levelIn, List<Component> tooltipIn, TooltipFlag flagIn) {
        if (this.isTowerShield && !stackIn.m_41619_() && stackIn.m_41782_() && stackIn.m_41783_().m_128441_("BlockEntityTag")) {
            DyeColor dyeColor = ShieldItem.m_43102_((ItemStack)stackIn);
            tooltipIn.add((Component)Component.m_237119_());
            tooltipIn.add((Component)Component.m_237115_((String)"tooltip.spartanshields.has_patterns"));
            tooltipIn.add((Component)Component.m_237115_((String)String.format("block.minecraft.%s_banner", dyeColor.name().toLowerCase())).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GRAY}));
            BannerItem.m_40542_((ItemStack)stackIn, tooltipIn);
        }
        this.addEffectsTooltip(stackIn, levelIn, tooltipIn, flagIn);
    }

    public String m_5671_(ItemStack stack) {
        return this.m_41467_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addEffectsTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.getEnchantmentLevel((Enchantment)ModEnchantments.PAYBACK.get()) != 0) {
            float paybackDamage = stack.m_41784_().m_128457_("PaybackDamage");
            tooltip.add((Component)Component.m_237110_((String)"tooltip.spartanshields.payback_bonus", (Object[])new Object[]{ChatFormatting.GRAY.toString() + Float.toString(paybackDamage)}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

