/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class ConditionalShapelessRecipeBuilder {
    private final ItemStack result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;
    private List<ICondition> conditions = new ArrayList<ICondition>();

    private ConditionalShapelessRecipeBuilder(ItemStack resultIn, int countIn) {
        this.result = resultIn;
        this.count = countIn;
    }

    public static ConditionalShapelessRecipeBuilder shapeless(ItemStack stackIn) {
        return new ConditionalShapelessRecipeBuilder(stackIn, 1);
    }

    public static ConditionalShapelessRecipeBuilder shapeless(ItemStack stackIn, int countIn) {
        return new ConditionalShapelessRecipeBuilder(stackIn, countIn);
    }

    public static ConditionalShapelessRecipeBuilder shapeless(ItemLike itemIn) {
        return new ConditionalShapelessRecipeBuilder(new ItemStack((ItemLike)itemIn.m_5456_()), 1);
    }

    public static ConditionalShapelessRecipeBuilder shapeless(ItemLike itemIn, int countIn) {
        return new ConditionalShapelessRecipeBuilder(new ItemStack((ItemLike)itemIn.m_5456_()), countIn);
    }

    public ConditionalShapelessRecipeBuilder requires(TagKey<Item> tagIn) {
        return this.requires(Ingredient.m_204132_(tagIn));
    }

    public ConditionalShapelessRecipeBuilder requires(TagKey<Item> tagIn, int countIn) {
        return this.requires(Ingredient.m_204132_(tagIn), countIn);
    }

    public ConditionalShapelessRecipeBuilder requires(ItemLike itemIn) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public ConditionalShapelessRecipeBuilder requires(ItemLike itemIn, int countIn) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}), countIn);
    }

    public ConditionalShapelessRecipeBuilder requires(Ingredient ingredientIn) {
        this.ingredients.add(ingredientIn);
        return this;
    }

    public ConditionalShapelessRecipeBuilder requires(Ingredient ingredientIn, int countIn) {
        for (int i = 0; i < countIn; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public ConditionalShapelessRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public ConditionalShapelessRecipeBuilder group(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public ConditionalShapelessRecipeBuilder condition(ICondition conditionIn) {
        this.conditions.add(conditionIn);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation saveLoc = new ResourceLocation(save);
        ResourceLocation resultLoc = ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_());
        if (saveLoc.equals((Object)resultLoc)) {
            throw new IllegalStateException("Shaped recipe " + save + " save argument is redundant as it's the same as the item id!");
        }
        this.save(consumerIn, saveLoc);
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("minecraft:recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.conditions, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("Impossible to obtain recipe " + String.valueOf(id) + "!");
        }
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final List<ICondition> conditions;

        public Result(ResourceLocation idIn, ItemStack resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, List<ICondition> conditionsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.ingredients = ingredientsIn;
            this.conditions = conditionsIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsArray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientsArray);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            if (this.result.m_41782_()) {
                resultJson.addProperty("nbt", this.result.m_41783_().toString());
            }
            json.add("result", (JsonElement)resultJson);
            JsonArray conditionArray = new JsonArray();
            for (ICondition condition : this.conditions) {
                conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)conditionArray);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

