/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.oil;

import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.util.Config;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;

public class PotionOilEffect
extends OilEffect {
    public PotionOilEffect() {
        super("potion", OilEffect.OilEffectType.EFFECT_ONLY, 0, 20, 0.0f, OilEffect.USE_NOTHING, true);
    }

    @Override
    public int getColor(ItemStack stackIn) {
        Potion potion = Potions.f_43598_;
        CompoundTag oilTag = stackIn.m_41784_().m_128469_("Oil");
        if (!oilTag.m_128456_()) {
            potion = PotionUtils.m_43577_((CompoundTag)oilTag);
            int color = PotionUtils.m_43559_((Potion)potion);
            return color;
        }
        return super.getColor(stackIn);
    }

    @Override
    public float onUse(float baseDamageIn, Level levelIn, LivingEntity targetEntityIn, LivingEntity userEntityIn, ItemStack oilStackIn) {
        Potion potion = Potions.f_43598_;
        CompoundTag oilTag = oilStackIn.m_41784_().m_128469_("Oil");
        if (!oilTag.m_128456_()) {
            potion = PotionUtils.m_43577_((CompoundTag)oilTag);
            potion.m_43488_().forEach(effect -> {
                if (effect.m_19544_().m_8093_()) {
                    int targetHurtTime = targetEntityIn.f_20916_;
                    targetEntityIn.f_20916_ = 0;
                    effect.m_19544_().m_19461_((Entity)userEntityIn, (Entity)userEntityIn, targetEntityIn, effect.m_19564_(), 1.0);
                    targetEntityIn.f_20916_ = targetHurtTime;
                } else {
                    targetEntityIn.m_147207_(new MobEffectInstance(effect.m_19544_(), Mth.m_14107_((double)((double)effect.m_19557_() * (Double)Config.INSTANCE.potionOilDurationModifier.get())), effect.m_19564_()), (Entity)userEntityIn);
                }
            });
        }
        return super.onUse(baseDamageIn, levelIn, targetEntityIn, userEntityIn, oilStackIn);
    }

    @Override
    public void getTooltip(ItemStack stackIn, List<Component> tooltipListIn) {
        OilHelper.addPotionTooltip(stackIn, tooltipListIn, ((Double)Config.INSTANCE.potionOilDurationModifier.get()).floatValue());
    }
}

