/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.oblivioussp.spartanweaponry.capability.IQuiverItemHandler;
import com.oblivioussp.spartanweaponry.client.gui.components.ToggleImageButton;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.inventory.QuiverBaseMenu;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.network.QuiverButtonPacket;
import com.oblivioussp.spartanweaponry.network.QuiverPrioritySlotPacket;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class QuiverBaseScreen<T extends QuiverBaseMenu>
extends AbstractContainerScreen<T> {
    protected final ResourceLocation GUI_TEXTURE_SMALL = new ResourceLocation("spartanweaponry", "textures/gui/quiver_small.png");
    protected final ResourceLocation GUI_TEXTURE_MEDIUM = new ResourceLocation("spartanweaponry", "textures/gui/quiver_medium.png");
    protected final ResourceLocation GUI_TEXTURE_LARGE = new ResourceLocation("spartanweaponry", "textures/gui/quiver_large.png");
    protected final ResourceLocation GUI_TEXTURE_HUGE = new ResourceLocation("spartanweaponry", "textures/gui/quiver_huge.png");
    protected final Component PRIORITY_BUTTON_TOOLTIP = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"gui.spartanweaponry.set_priority_slot")).m_7220_((Component)Component.m_237113_((String)"]"));
    protected final Component AMMO_COLLECT_ENABLED_BUTTON_TOOLTIP = Component.m_237115_((String)"gui.spartanweaponry.ammo_collect_enabled");
    protected final Component AMMO_COLLECT_DISABLED_BUTTON_TOOLTIP = Component.m_237115_((String)"gui.spartanweaponry.ammo_collect_disabled");
    protected final ResourceLocation texture;
    protected final ItemStack quiver;
    protected final int ammoSlots;
    protected int prioritySlot = 0;
    protected boolean isAmmoCollectEnabled;

    public QuiverBaseScreen(T screenContainer, Inventory inv, Component title) {
        super(screenContainer, inv, title);
        this.quiver = ((QuiverBaseMenu)((Object)screenContainer)).getQuiverStack();
        this.prioritySlot = this.quiver.m_41784_().m_128451_("PrioritySlot");
        this.isAmmoCollectEnabled = this.quiver.m_41784_().m_128471_("AmmoCollect");
        LazyOptional handler = this.quiver.getCapability(ModCapabilities.QUIVER_ITEM_CAPABILITY);
        this.ammoSlots = handler.isPresent() ? ((IQuiverItemHandler)handler.resolve().orElseThrow()).getSlots() : 4;
        switch (this.ammoSlots) {
            case 12: {
                this.texture = this.GUI_TEXTURE_HUGE;
                break;
            }
            case 9: {
                this.texture = this.GUI_TEXTURE_LARGE;
                break;
            }
            case 6: {
                this.texture = this.GUI_TEXTURE_MEDIUM;
                break;
            }
            case 4: {
                this.texture = this.GUI_TEXTURE_SMALL;
                break;
            }
            default: {
                this.texture = new ResourceLocation("spartanweaponry", "textures/gui/missingno.png");
                Log.error("Missing texture for GUI for quiver: " + this.quiver.m_41786_().toString());
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        ToggleImageButton ammoCollectButton = new ToggleImageButton(this.isAmmoCollectEnabled, this.f_97735_ - 18, this.f_97736_ + 20, 16, 16, 177, 39, 17, 17, this.texture, 256, 256, button -> {
            this.isAmmoCollectEnabled = !this.isAmmoCollectEnabled;
            button.m_257544_(Tooltip.m_257550_((Component)(this.isAmmoCollectEnabled ? this.AMMO_COLLECT_ENABLED_BUTTON_TOOLTIP : this.AMMO_COLLECT_DISABLED_BUTTON_TOOLTIP)));
            NetworkHandler.sendPacketToServer(new QuiverButtonPacket(this.isAmmoCollectEnabled));
        }, (Component)Component.m_237119_());
        ammoCollectButton.m_257544_(Tooltip.m_257550_((Component)(this.isAmmoCollectEnabled ? this.AMMO_COLLECT_ENABLED_BUTTON_TOOLTIP : this.AMMO_COLLECT_DISABLED_BUTTON_TOOLTIP)));
        this.m_142416_((GuiEventListener)ammoCollectButton);
        for (int i = 0; i < this.ammoSlots; ++i) {
            Slot slot = ((QuiverBaseMenu)this.f_97732_).m_38853_(i);
            ImageButton priorityButton = new ImageButton(this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 7, 7, 177, 1, 8, this.texture, 256, 256, button -> {
                this.prioritySlot = this.f_97734_.m_150661_();
                NetworkHandler.sendPacketToServer(new QuiverPrioritySlotPacket(this.f_97734_.m_150661_()));
            }, (Component)Component.m_237119_());
            this.m_142416_((GuiEventListener)priorityButton);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (((QuiverBaseMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            List tooltipList = QuiverBaseScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)this.f_97734_.m_7993_());
            if (this.f_97734_.f_40219_ < this.ammoSlots && mouseX > this.f_97735_ + this.f_97734_.f_40220_ - 1 && mouseX < this.f_97735_ + this.f_97734_.f_40220_ + 6 && mouseY > this.f_97736_ + this.f_97734_.f_40221_ - 1 && mouseY < this.f_97736_ + this.f_97734_.f_40221_ + 6) {
                tooltipList.add(0, this.PRIORITY_BUTTON_TOOLTIP);
            }
            this.m_280072_(guiGraphics, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        guiGraphics.m_280218_(this.texture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int offhandY = this.ammoSlots == 12 ? 122 : 104;
        guiGraphics.m_280218_(this.texture, this.f_97735_ - 27, this.f_97736_ + offhandY, 178, offhandY, 27, 29);
        Slot highlightedSlot = (Slot)((QuiverBaseMenu)this.f_97732_).f_38839_.get(this.prioritySlot);
        QuiverBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(this.f_97735_ + highlightedSlot.f_40220_), (int)(this.f_97736_ + highlightedSlot.f_40221_), (int)0, (int)-2143240128);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String name = this.quiver.m_41786_().getString();
        guiGraphics.m_280614_(this.f_96547_, this.quiver.m_41786_(), this.f_97726_ / 2 - this.f_96547_.m_92895_(name) / 2, 5, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, 8, 42 + (this.ammoSlots == 12 ? 18 : 0), 0x404040, false);
    }
}

