/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class ArrowBaseEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected final String NBT_ARROW = "Arrow";
    protected final String NBT_POTION = "Potion";
    protected final String NBT_POTION_COLOUR = "PotionColour";
    protected static final EntityDataAccessor<Integer> COLOUR = SynchedEntityData.m_135353_(ArrowBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<ItemStack> ARROW = SynchedEntityData.m_135353_(ArrowBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected Potion potion = Potions.f_43598_;
    protected float baseDamage = 1.0f;
    protected float rangeMultiplier = 1.0f;

    public ArrowBaseEntity(EntityType<? extends ArrowBaseEntity> type, Level level) {
        super(type, level);
    }

    public ArrowBaseEntity(Level level, double x, double y, double z) {
        super((EntityType)ModEntities.ARROW_SW.get(), x, y, z, level);
    }

    public ArrowBaseEntity(Level level, LivingEntity shooter) {
        super((EntityType)ModEntities.ARROW_SW.get(), shooter, level);
    }

    public ArrowBaseEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends ArrowBaseEntity>)((EntityType)ModEntities.ARROW_SW.get()), level);
    }

    public void initEntity(float baseDamage, float rangeMultiplier, ItemStack arrowStack) {
        this.baseDamage = baseDamage;
        this.rangeMultiplier = rangeMultiplier;
        this.m_36781_(baseDamage);
        this.setArrowStack(arrowStack);
    }

    public void m_37251_(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        super.m_37251_(shooter, pitch, yaw, p_184547_4_, velocity * this.rangeMultiplier, inaccuracy);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOUR, (Object)-1);
        this.m_20088_().m_135372_(ARROW, (Object)ItemStack.f_41583_);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && this.f_36704_ >= 600) {
            level.m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.m_20088_().m_135381_(COLOUR, (Object)-1);
        }
    }

    protected void m_7761_(LivingEntity living) {
        Entity entity = this.m_150173_();
        Level level = this.m_9236_();
        for (MobEffectInstance effect : this.potion.m_43488_()) {
            living.m_147207_(new MobEffectInstance(effect.m_19544_(), Math.max(effect.m_19557_() / 8, 1), effect.m_19564_(), effect.m_19571_(), effect.m_19572_()), entity);
        }
        Item arrowItem = this.m_7941_().m_41720_();
        if ((level.m_46470_() && arrowItem == ModItems.COPPER_ARROW.get() || arrowItem == ModItems.TIPPED_COPPER_ARROW.get()) && this.f_19796_.m_188503_(4) < 1) {
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            lightning.m_20219_(Vec3.m_82539_((Vec3i)living.m_20183_()));
            lightning.m_20879_(living instanceof ServerPlayer ? (ServerPlayer)living : null);
            level.m_7967_((Entity)lightning);
        }
    }

    public void m_7822_(byte id) {
        if (id == 0) {
            Level level = this.m_9236_();
            int i = (Integer)this.m_20088_().m_135370_(COLOUR);
            if (i != -1) {
                double cR = (double)(i >> 16 & 0xFF) / 255.0;
                double cG = (double)(i >> 8 & 0xFF) / 255.0;
                double cB = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), cR, cG, cB);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected ItemStack m_7941_() {
        return (ItemStack)this.m_20088_().m_135370_(ARROW);
    }

    protected void setArrowStack(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        this.m_20088_().m_135381_(ARROW, (Object)copy);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.m_7941_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag nbt = new CompoundTag();
        nbt = this.m_7941_().m_41739_(nbt);
        compound.m_128365_("Arrow", (Tag)nbt);
        if (this.potion != null && this.potion != Potions.f_43598_) {
            compound.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)this.potion).toString());
        }
        compound.m_128405_("PotionColour", ((Integer)this.m_20088_().m_135370_(COLOUR)).intValue());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setArrowStack(additionalData.m_130267_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        CompoundTag nbt = compound.m_128469_("Arrow");
        this.setArrowStack(ItemStack.m_41712_((CompoundTag)nbt));
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        this.m_20088_().m_135381_(COLOUR, (Object)(compound.m_128441_("PotionColour") ? compound.m_128451_("PotionColour") : -1));
    }

    public boolean isValid() {
        return !this.m_7941_().m_41619_();
    }

    public ResourceLocation getTexture() {
        String prefix;
        String arrowRegName = ForgeRegistries.ITEMS.getKey((Object)this.m_7941_().m_41720_()).m_135815_();
        int idx = arrowRegName.indexOf(prefix = "tipped_");
        if (idx != -1) {
            arrowRegName = arrowRegName.substring(idx + prefix.length());
        }
        return new ResourceLocation("spartanweaponry", "textures/entity/projectiles/" + arrowRegName + ".png");
    }

    public void setPotionEffect(ItemStack stack) {
        this.potion = PotionUtils.m_43579_((ItemStack)stack);
        this.m_20088_().m_135381_(COLOUR, (Object)PotionUtils.m_43575_((ItemStack)stack));
    }

    public void spawnPotionParticles(int particleCount) {
        int colour = (Integer)this.m_20088_().m_135370_(COLOUR);
        if (colour != -1 && particleCount > 0) {
            Level level = this.m_9236_();
            double cR = (double)(colour >> 16 & 0xFF) / 255.0;
            double cG = (double)(colour >> 8 & 0xFF) / 255.0;
            double cB = (double)(colour >> 0 & 0xFF) / 255.0;
            for (int i = 0; i < particleCount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), cR, cG, cB);
            }
        }
    }
}

