/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.google.common.collect.Lists;
import com.oblivioussp.spartanweaponry.init.ModDamageTypes;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BoltEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected final String NBT_BOLT = "Bolt";
    protected final String NBT_POTION = "Potion";
    protected final String NBT_POTION_COLOUR = "PotionColour";
    protected static final EntityDataAccessor<Integer> DATA_COLOUR = SynchedEntityData.m_135353_(BoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<ItemStack> DATA_BOLT = SynchedEntityData.m_135353_(BoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected Potion potion = Potions.f_43598_;
    protected float baseDamage = 1.0f;
    protected float rangeMultiplier = 1.0f;
    protected float armorPiercingFactor = 0.0f;

    public BoltEntity(EntityType<? extends BoltEntity> type, Level level) {
        super(type, level);
    }

    public BoltEntity(EntityType<? extends BoltEntity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public BoltEntity(EntityType<? extends BoltEntity> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    public BoltEntity(LivingEntity shooter, Level level) {
        this((EntityType<? extends BoltEntity>)((EntityType)ModEntities.BOLT.get()), shooter, level);
    }

    public BoltEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends BoltEntity>)((EntityType)ModEntities.BOLT.get()), level);
    }

    public void initEntity(float baseDamage, float rangeMultiplier, float armorPiercingFactor, ItemStack boltStack) {
        this.baseDamage = baseDamage;
        this.rangeMultiplier = rangeMultiplier;
        this.armorPiercingFactor = armorPiercingFactor;
        this.m_36781_(baseDamage);
        this.m_20088_().m_135381_(DATA_BOLT, (Object)boltStack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_COLOUR, (Object)-1);
        this.m_20088_().m_135372_(DATA_BOLT, (Object)ItemStack.f_41583_);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && this.f_36704_ >= 600) {
            level.m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.m_20088_().m_135381_(DATA_COLOUR, (Object)-1);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        DamageSource source;
        Entity shooter;
        Level level = this.m_9236_();
        Entity entity = result.m_82443_();
        float velocity = (float)this.m_20184_().m_82553_();
        int damage = Mth.m_14165_((double)Mth.m_14008_((double)((double)velocity * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity.m_19879_());
        }
        if (this.m_36792_()) {
            long critDamageBonus = this.f_19796_.m_188503_(damage / 2 + 2);
            damage = (int)Math.min(critDamageBonus + (long)damage, Integer.MAX_VALUE);
        }
        if ((shooter = this.m_19749_()) == null) {
            source = ModDamageTypes.armorPiercingProjectile((Entity)this, (Entity)this);
        } else {
            source = ModDamageTypes.armorPiercingProjectile((Entity)this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).m_21335_(entity);
            }
        }
        boolean isEnderman = entity.m_6095_() == EntityType.f_20566_;
        int fireTimer = entity.m_20094_();
        if (this.m_6060_() && !isEnderman) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(source, (float)damage)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!level.f_46443_ && this.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.m_150123_() > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!level.f_46443_ && shooter instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)shooter);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)shooter), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
                if (shooter != null && livingentity != shooter && livingentity instanceof Player && shooter instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)shooter).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(livingentity);
                }
                if (!level.f_46443_ && shooter instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)shooter;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, (Collection)this.f_36702_);
                    } else if (!entity.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            entity.m_7311_(fireTimer);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!level.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        Level level = this.m_9236_();
        for (MobEffectInstance effect : this.potion.m_43488_()) {
            living.m_7292_(new MobEffectInstance(effect.m_19544_(), Math.max(effect.m_19557_() / 8, 1), effect.m_19564_(), effect.m_19571_(), effect.m_19572_()));
        }
        Item arrowItem = this.m_7941_().m_41720_();
        if ((level.m_46470_() && arrowItem == ModItems.COPPER_BOLT.get() || arrowItem == ModItems.TIPPED_COPPER_BOLT.get()) && this.f_19796_.m_188503_(4) < 1) {
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            lightning.m_20219_(Vec3.m_82539_((Vec3i)living.m_20183_()));
            lightning.m_20879_(living instanceof ServerPlayer ? (ServerPlayer)living : null);
            level.m_7967_((Entity)lightning);
        }
    }

    protected ItemStack m_7941_() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_BOLT);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.m_20334_(x, y, z);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        this.m_20088_().m_135381_(DATA_COLOUR, (Object)(compound.m_128441_("PotionColour") ? compound.m_128451_("PotionColour") : -1));
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.m_20184_().f_82479_);
        buffer.writeDouble(this.m_20184_().f_82480_);
        buffer.writeDouble(this.m_20184_().f_82481_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.potion != null && this.potion != Potions.f_43598_) {
            compound.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)this.potion).toString());
        }
        compound.m_128405_("PotionColour", ((Integer)this.m_20088_().m_135370_(DATA_COLOUR)).intValue());
    }

    public float getRangeMultiplier() {
        return this.rangeMultiplier;
    }

    public void setPotionEffect(ItemStack stack) {
        this.potion = PotionUtils.m_43579_((ItemStack)stack);
        this.m_20088_().m_135381_(DATA_COLOUR, (Object)PotionUtils.m_43575_((ItemStack)stack));
    }

    private void spawnPotionParticles(int particleCount) {
        int colour = (Integer)this.m_20088_().m_135370_(DATA_COLOUR);
        if (colour != -1 && particleCount > 0) {
            Level level = this.m_9236_();
            double cR = (double)(colour >> 16 & 0xFF) / 255.0;
            double cG = (double)(colour >> 8 & 0xFF) / 255.0;
            double cB = (double)(colour >> 0 & 0xFF) / 255.0;
            for (int i = 0; i < particleCount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), cR, cG, cB);
            }
        }
    }

    public boolean isValid() {
        return !this.m_7941_().m_41619_();
    }

    public ResourceLocation getTexture() {
        String prefix;
        ItemStack boltStack = this.m_7941_();
        if (boltStack.m_41619_()) {
            return new ResourceLocation("spartanweaponry", "missing_stack");
        }
        String boltRegName = ForgeRegistries.ITEMS.getKey((Object)boltStack.m_41720_()).m_135815_();
        int idx = boltRegName.indexOf(prefix = "tipped_");
        if (idx != -1) {
            boltRegName = boltRegName.substring(idx + prefix.length());
        }
        return new ResourceLocation("spartanweaponry", "textures/entity/projectiles/" + boltRegName + ".png");
    }
}

