/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.entity.projectile.BoltEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class BoltItem
extends Item {
    protected float damageModifier = 4.0f;
    protected float rangeModifier = 1.0f;
    protected float armorPiercingFactor = 0.25f;

    public BoltItem(float damageModifier, float rangeModifier, float armorPiercingFactor) {
        super(new Item.Properties());
        this.damageModifier = damageModifier;
        this.rangeModifier = rangeModifier;
        this.armorPiercingFactor = armorPiercingFactor;
    }

    public BoltEntity createBolt(Level level, ItemStack stack, LivingEntity shooter) {
        BoltEntity bolt = new BoltEntity(shooter, level);
        ItemStack boltStack = stack.m_41777_();
        boltStack.m_41764_(1);
        bolt.initEntity(this.damageModifier, this.rangeModifier, this.armorPiercingFactor, boltStack);
        if (bolt.isValid()) {
            return bolt;
        }
        return null;
    }

    public boolean isInfinite(ItemStack stack, ItemStack crossbow, Player player) {
        int enchant = crossbow.getEnchantmentLevel(Enchantments.f_44952_);
        return enchant <= 0 ? false : ((Object)((Object)this)).getClass() == BoltItem.class;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.spartanweaponry.modifiers.projectile.base_damage", (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanweaponry.modifiers.projectile.base_damage.value", (Object[])new Object[]{Float.valueOf(this.damageModifier)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.spartanweaponry.modifiers.projectile.range", (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanweaponry.modifiers.projectile.range.value", (Object[])new Object[]{Float.valueOf(this.rangeModifier)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.spartanweaponry.modifiers.projectile.armor_piercing_factor", (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanweaponry.modifiers.projectile.armor_piercing_factor.value", (Object[])new Object[]{Float.valueOf(this.armorPiercingFactor * 100.0f)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public void updateFromConfig(float damageModifier, float rangeModifier, float armorPiercingFactor) {
        this.damageModifier = damageModifier;
        this.rangeModifier = rangeModifier;
        this.armorPiercingFactor = armorPiercingFactor;
    }
}

