/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.capability.IQuiverItemHandler;
import com.oblivioussp.spartanweaponry.capability.QuiverCapabilityProvider;
import com.oblivioussp.spartanweaponry.capability.QuiverCurioCapabilityProvider;
import com.oblivioussp.spartanweaponry.capability.QuiverItemStackHandler;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.inventory.tooltip.QuiverTooltip;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public abstract class QuiverBaseItem
extends Item {
    public static final String NBT_AMMO_COLLECT = "AmmoCollect";
    public static final String NBT_AMMO = "Ammo";
    public static final String NBT_OFFHAND_MOVED = "OffhandMoved";
    public static final String NBT_ITEM_ID = "Id";
    public static final String NBT_ITEM_SLOT = "Slot";
    public static final String NBT_PROIRITY_SLOT = "PrioritySlot";
    protected int ammoSlots = 4;

    public QuiverBaseItem(int inventorySize) {
        super(new Item.Properties().m_41487_(1));
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerQuiverPropertyOverrides(this);
        }
        this.ammoSlots = inventorySize;
    }

    public int getAmmoCount(ItemStack stack) {
        int ammo = 0;
        ListTag list = null;
        list = stack.m_41784_().m_128469_(NBT_AMMO).m_128437_("Items", 10);
        if (list == null) {
            return 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
            if (item.m_41619_()) continue;
            ++ammo;
        }
        ammo = this.ammoSlots >= 9 ? Mth.m_14045_((int)ammo, (int)0, (int)5) : Mth.m_14045_((int)ammo, (int)0, (int)3);
        return ammo;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (ModList.get().isLoaded("curios")) {
            return new QuiverCurioCapabilityProvider(stack, this.ammoSlots, nbt, this);
        }
        return new QuiverCapabilityProvider(stack, this.ammoSlots, nbt);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        IQuiverItemHandler handler = (IQuiverItemHandler)heldItem.getCapability(ModCapabilities.QUIVER_ITEM_CAPABILITY).resolve().orElseThrow();
        int size = heldItem.m_41698_(NBT_AMMO).m_128451_("Size");
        if (size != this.ammoSlots) {
            handler.resize(this.ammoSlots);
        }
        if (!levelIn.f_46443_) {
            if (!playerIn.m_6047_()) {
                SlotType slotType = handIn == InteractionHand.OFF_HAND ? SlotType.OFF_HAND : SlotType.MAIN_HAND;
                this.openGui(heldItem, playerIn, slotType, -1);
                return InteractionResultHolder.m_19096_((Object)heldItem);
            }
            boolean ammoCollect = !heldItem.m_41784_().m_128471_(NBT_AMMO_COLLECT);
            heldItem.m_41783_().m_128379_(NBT_AMMO_COLLECT, ammoCollect);
            String collectStatus = ammoCollect ? "enabled" : "disabled";
            ChatFormatting collectColour = ammoCollect ? ChatFormatting.GREEN : ChatFormatting.RED;
            playerIn.m_5661_((Component)Component.m_237110_((String)"message.spartanweaponry.ammo_collect_toggle", (Object[])new Object[]{Component.m_237115_((String)("tooltip.spartanweaponry." + collectStatus)).m_130940_(collectColour)}), true);
            return InteractionResultHolder.m_19100_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            QuiverItemStackHandler handler = (QuiverItemStackHandler)stack.getCapability(ModCapabilities.QUIVER_ITEM_CAPABILITY).resolve().orElseThrow();
            handler.deserializeNBT(nbt.m_128469_(NBT_AMMO));
        }
    }

    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41784_().m_128441_("ClientInventory")) {
            stack.m_41784_().m_128473_("ClientInventory");
        }
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        boolean ammoCollect = stack.m_41784_().m_128471_(NBT_AMMO_COLLECT);
        String collectStatus = ammoCollect ? "enabled" : "disabled";
        ChatFormatting statusColour = ammoCollect ? ChatFormatting.GREEN : ChatFormatting.RED;
        tooltip.add((Component)Component.m_237115_((String)"tooltip.spartanweaponry.quiver_collect_status").m_7220_((Component)Component.m_237115_((String)("tooltip.spartanweaponry." + collectStatus)).m_130940_(statusColour)).m_130940_(ChatFormatting.DARK_AQUA));
        if (this.ammoSlots != 12) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.spartanweaponry.quiver_upgrade").m_130940_(ChatFormatting.YELLOW));
        }
    }

    public Optional<TooltipComponent> makeTooltipImage(ItemStack stackIn, boolean isBoltQuiver) {
        ListTag list = stackIn.m_41784_().m_128469_(NBT_AMMO).m_128437_("Items", 10);
        int prioritySlot = stackIn.m_41784_().m_128451_(NBT_PROIRITY_SLOT);
        NonNullList items = NonNullList.m_122780_((int)this.ammoSlots, (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            ItemStack slotStack = ItemStack.m_41712_((CompoundTag)tag);
            int slot = tag.m_128451_(NBT_ITEM_SLOT);
            items.set(slot, (Object)slotStack);
        }
        return Optional.of(new QuiverTooltip((NonNullList<ItemStack>)items, prioritySlot, isBoltQuiver));
    }

    public abstract Optional<TooltipComponent> m_142422_(ItemStack var1);

    public abstract void openGui(ItemStack var1, Player var2, SlotType var3, int var4);

    public abstract boolean isAmmoValid(ItemStack var1, ItemStack var2);

    public static enum SlotType {
        UNDEFINED,
        MAIN_HAND,
        OFF_HAND,
        HOTBAR,
        CURIO;

    }
}

