/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class OilBrewingRecipe
implements IBrewingRecipe {
    private static final List<OilMix> VALID_MIXES = new ArrayList<OilMix>();

    public boolean isInput(ItemStack input) {
        return input.m_150930_((Item)ModItems.WEAPON_OIL.get());
    }

    public boolean isIngredient(ItemStack ingredient) {
        for (OilMix mix : VALID_MIXES) {
            if (!mix.brewingIngredient.test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            OilEffect effect = OilHelper.getOilFromStack(input);
            for (OilMix mix : VALID_MIXES) {
                if (mix.from != effect || !mix.brewingIngredient.test(ingredient)) continue;
                return OilHelper.makeOilStack(mix.to);
            }
        }
        return ItemStack.f_41583_;
    }

    public static int getBrewingSteps(OilEffect effect) {
        OilEffect currentEffect = effect;
        int steps = 0;
        do {
            int currentSteps = steps;
            for (OilMix mix : VALID_MIXES) {
                if (currentEffect != mix.to) continue;
                ++steps;
                currentEffect = mix.from;
                break;
            }
            if (currentSteps != steps) continue;
            return Integer.MAX_VALUE;
        } while (currentEffect != OilEffects.NONE.get());
        return steps;
    }

    public static void clearMixes() {
        VALID_MIXES.clear();
    }

    public static void addBaseOilMix(Ingredient ingredientIn, OilEffect oilEffectOut) {
        VALID_MIXES.add(new OilMix((OilEffect)OilEffects.NONE.get(), ingredientIn, oilEffectOut));
    }

    public static void addOilMix(OilEffect oilEffectIn, Ingredient ingredientIn, OilEffect oilEffectOut) {
        VALID_MIXES.add(new OilMix(oilEffectIn, ingredientIn, oilEffectOut));
    }

    public static List<OilMix> getValidMixes() {
        return ImmutableList.copyOf(VALID_MIXES);
    }

    public static class OilMix {
        public final OilEffect from;
        public final OilEffect to;
        public final Ingredient brewingIngredient;

        public OilMix(OilEffect oilEffectIn, Ingredient ingredientIn, OilEffect oilEffectOut) {
            this.from = oilEffectIn;
            this.brewingIngredient = ingredientIn;
            this.to = oilEffectOut;
        }
    }
}

