/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.tags.ModWeaponTraitTags;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.util.Config;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.tuple.Pair;

public class WeaponArchetype
implements IReloadable {
    public static final WeaponArchetype DAGGER = new WeaponArchetype("Dagger", true, ModWeaponTraitTags.DAGGER, WeaponType.MELEE, () -> (Double)Config.INSTANCE.daggers.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.daggers.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.daggers.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype PARRYING_DAGGER = new WeaponArchetype("Parrying Dagger", true, ModWeaponTraitTags.PARRYING_DAGGER, WeaponType.MELEE, () -> (Double)Config.INSTANCE.parryingDaggers.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.parryingDaggers.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.parryingDaggers.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype LONGSWORD = new WeaponArchetype("Longsword", true, ModWeaponTraitTags.LONGSWORD, WeaponType.MELEE, () -> (Double)Config.INSTANCE.longswords.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.longswords.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.longswords.damageMultipler.get()).floatValue()), ToolActions.SWORD_DIG);
    public static final WeaponArchetype KATANA = new WeaponArchetype("Katana", true, ModWeaponTraitTags.KATANA, WeaponType.MELEE, () -> (Double)Config.INSTANCE.katanas.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.katanas.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.katanas.damageMultipler.get()).floatValue()), ToolActions.SWORD_DIG);
    public static final WeaponArchetype SABER = new WeaponArchetype("Saber", true, ModWeaponTraitTags.SABER, WeaponType.MELEE, () -> (Double)Config.INSTANCE.sabers.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.sabers.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.sabers.damageMultipler.get()).floatValue()), ToolActions.SWORD_DIG);
    public static final WeaponArchetype RAPIER = new WeaponArchetype("Rapier", true, ModWeaponTraitTags.RAPIER, WeaponType.MELEE, () -> (Double)Config.INSTANCE.rapiers.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.rapiers.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.rapiers.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype GREATSWORD = new WeaponArchetype("Greatsword", true, ModWeaponTraitTags.GREATSWORD, WeaponType.MELEE, () -> (Double)Config.INSTANCE.greatswords.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.greatswords.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.greatswords.damageMultipler.get()).floatValue()), ToolActions.SWORD_DIG);
    public static final WeaponArchetype CLUB = new WeaponArchetype("Club", false, ModWeaponTraitTags.CLUB, WeaponType.MELEE, () -> (Double)Config.INSTANCE.clubs.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.clubs.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.clubs.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype CESTUS = new WeaponArchetype("Cestus", false, ModWeaponTraitTags.CESTUS, WeaponType.MELEE, () -> (Double)Config.INSTANCE.cestus.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.cestus.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.cestus.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype BATTLE_HAMMER = new WeaponArchetype("Battle Hammer", false, ModWeaponTraitTags.BATTLE_HAMMER, WeaponType.MELEE, () -> (Double)Config.INSTANCE.battleHammers.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.battleHammers.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.battleHammers.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype WARHAMMER = new WeaponArchetype("Warhammer", false, ModWeaponTraitTags.WARHAMMER, WeaponType.MELEE, () -> (Double)Config.INSTANCE.warhammers.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.warhammers.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.warhammers.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype SPEAR = new WeaponArchetype("Spear", false, ModWeaponTraitTags.SPEAR, WeaponType.MELEE, () -> (Double)Config.INSTANCE.spears.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.spears.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.spears.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype HALBERD = new WeaponArchetype("Halberd", false, ModWeaponTraitTags.HALBERD, WeaponType.MELEE, () -> (Double)Config.INSTANCE.halberds.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.halberds.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.halberds.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype PIKE = new WeaponArchetype("Pike", false, ModWeaponTraitTags.PIKE, WeaponType.MELEE, () -> (Double)Config.INSTANCE.pikes.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.pikes.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.pikes.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype LANCE = new WeaponArchetype("Lance", false, ModWeaponTraitTags.LANCE, WeaponType.MELEE, () -> (Double)Config.INSTANCE.lances.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.lances.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.lances.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype THROWING_KNIFE = new WeaponArchetype("Throwing Knife", true, ModWeaponTraitTags.THROWING_KNIFE, WeaponType.THROWING, () -> (Double)Config.INSTANCE.throwingKnives.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.throwingKnives.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.throwingKnives.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype TOMAHAWK = new WeaponArchetype("Tomahawk", false, ModWeaponTraitTags.TOMAHAWK, WeaponType.THROWING, () -> (Double)Config.INSTANCE.tomahawks.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.tomahawks.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.tomahawks.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype JAVELIN = new WeaponArchetype("Javelin", false, ModWeaponTraitTags.JAVELIN, WeaponType.THROWING, () -> (Double)Config.INSTANCE.javelins.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.javelins.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.javelins.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype BOOMERANG = new WeaponArchetype("Boomerang", false, ModWeaponTraitTags.BOOMERANG, WeaponType.THROWING, () -> (Double)Config.INSTANCE.boomerangs.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.boomerangs.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.boomerangs.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype BATTLEAXE = new WeaponArchetype("Battleaxe", false, ModWeaponTraitTags.BATTLEAXE, WeaponType.MELEE, () -> (Double)Config.INSTANCE.battleaxes.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.battleaxes.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.battleaxes.damageMultipler.get()).floatValue()), ToolActions.DEFAULT_AXE_ACTIONS);
    public static final WeaponArchetype FLANGED_MACE = new WeaponArchetype("Flanged Mace", false, ModWeaponTraitTags.FLANGED_MACE, WeaponType.MELEE, () -> (Double)Config.INSTANCE.flangedMaces.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.flangedMaces.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.flangedMaces.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype GLAIVE = new WeaponArchetype("Glaive", true, ModWeaponTraitTags.GLAIVE, WeaponType.MELEE, () -> (Double)Config.INSTANCE.glaives.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.glaives.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.glaives.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype QUARTERSTAFF = new WeaponArchetype("Quarterstaff", false, ModWeaponTraitTags.QUARTERSTAFF, WeaponType.MELEE, () -> (Double)Config.INSTANCE.quarterstaves.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.quarterstaves.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.quarterstaves.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final WeaponArchetype SCYTHE = new WeaponArchetype("Scythe", false, ModWeaponTraitTags.SCYTHE, WeaponType.MELEE, () -> (Double)Config.INSTANCE.scythes.speed.get(), () -> Float.valueOf(((Double)Config.INSTANCE.scythes.baseDamage.get()).floatValue()), () -> Float.valueOf(((Double)Config.INSTANCE.scythes.damageMultipler.get()).floatValue()), new ToolAction[0]);
    public static final List<WeaponArchetype> ALL_ARCHETYPES = ImmutableList.of((Object)DAGGER, (Object)PARRYING_DAGGER, (Object)LONGSWORD, (Object)KATANA, (Object)SABER, (Object)RAPIER, (Object)GREATSWORD, (Object)CLUB, (Object)CESTUS, (Object)BATTLE_HAMMER, (Object)WARHAMMER, (Object)SPEAR, (Object[])new WeaponArchetype[]{HALBERD, PIKE, LANCE, THROWING_KNIFE, TOMAHAWK, JAVELIN, BOOMERANG, BATTLEAXE, FLANGED_MACE, GLAIVE, QUARTERSTAFF, SCYTHE});
    protected final String name;
    protected final TagKey<WeaponTrait> traitsTag;
    protected boolean isValidTag = true;
    protected List<WeaponTrait> traits = ImmutableList.of();
    protected Optional<WeaponTrait> actionTrait = Optional.empty();
    protected Optional<List<Pair<WeaponTrait, WeaponTrait.InvalidReason>>> invalidTraits = Optional.empty();
    protected final WeaponType type;
    protected final boolean isBladed;
    protected final Set<ToolAction> toolActions;
    protected final Supplier<Double> speedValue;
    protected final Supplier<Float> baseDamage;
    protected final Supplier<Float> damageMultiplier;

    public WeaponArchetype(String nameIn, boolean isBladedIn, TagKey<WeaponTrait> traitsTagIn, WeaponType typeIn, Supplier<Double> speedValueIn, Supplier<Float> baseDamageIn, Supplier<Float> damageMultiplierIn, Set<ToolAction> toolActionsIn) {
        this.name = nameIn;
        this.traitsTag = traitsTagIn;
        this.type = typeIn;
        this.isBladed = isBladedIn;
        this.toolActions = toolActionsIn;
        this.speedValue = speedValueIn;
        this.baseDamage = baseDamageIn;
        this.damageMultiplier = damageMultiplierIn;
    }

    public WeaponArchetype(String nameIn, boolean isBladedIn, TagKey<WeaponTrait> traitsTagIn, WeaponType typeIn, Supplier<Double> speedValueIn, Supplier<Float> baseDamageIn, Supplier<Float> damageMultiplierIn, ToolAction ... toolActionsIn) {
        this(nameIn, isBladedIn, traitsTagIn, typeIn, speedValueIn, baseDamageIn, damageMultiplierIn, (Set<ToolAction>)ImmutableSet.copyOf((Object[])toolActionsIn));
    }

    @Override
    public void reload() {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(WeaponTraits.REGISTRY_KEY);
        ITagManager tagManager = registry.tags();
        this.isValidTag = tagManager.isKnownTagName(this.traitsTag);
        if (!this.isValidTag) {
            Log.error("Weapon Trait tag \"" + String.valueOf(this.traitsTag.f_203868_()) + "\" couldn't be found for weapon archetype \"" + this.name + "\"!");
            return;
        }
        ITag tag = tagManager.getTag(this.traitsTag);
        this.invalidTraits = Optional.empty();
        ArrayList invalidTraitList = new ArrayList();
        ArrayList invalidTraitValues = new ArrayList();
        AtomicReference<Object> actionTraitRef = new AtomicReference<Object>(null);
        this.traits = tag.stream().filter(trait -> {
            boolean isValid = this.type.getTraitFilter().test((WeaponTrait)trait);
            if (isValid && trait.isActionTrait()) {
                if (actionTraitRef.get() == null) {
                    actionTraitRef.set(trait);
                    return isValid;
                }
                invalidTraitList.add(Pair.of((Object)trait, (Object)((Object)WeaponTrait.InvalidReason.MULTIPLE_ACTION_TRAITS)));
                invalidTraitValues.add(registry.getKey(trait).toString());
                return false;
            }
            if (isValid) return isValid;
            WeaponTrait.InvalidReason reason = trait.isMeleeTrait() ? WeaponTrait.InvalidReason.WEAPON_NOT_MELEE : (trait.isRangedTrait() ? WeaponTrait.InvalidReason.WEAPON_NOT_RANGED : (trait.isThrowingTrait() ? WeaponTrait.InvalidReason.WEAPON_NOT_THROWING : WeaponTrait.InvalidReason.WEAPON_NOT_SUPPORTED));
            invalidTraitList.add(Pair.of((Object)trait, (Object)((Object)reason)));
            invalidTraitValues.add(registry.getKey(trait).toString());
            return isValid;
        }).collect(Collectors.toUnmodifiableList());
        WeaponTrait trait2 = actionTraitRef.get();
        Optional<Object> optional = this.actionTrait = trait2 != null ? Optional.of(actionTraitRef.get()) : Optional.empty();
        if (!invalidTraitList.isEmpty()) {
            Log.warn("Found invalid Weapon Traits for weapon archetype \"" + this.name + "\" which have not been added: " + String.join((CharSequence)", ", invalidTraitValues));
            this.invalidTraits = Optional.of(invalidTraitList);
        }
    }

    public boolean isBladed() {
        return this.isBladed;
    }

    public boolean canPerformToolAction(ToolAction toolAction) {
        return this.toolActions.contains(toolAction);
    }

    public List<WeaponTrait> getTraits() {
        return this.traits;
    }

    public Optional<List<Pair<WeaponTrait, WeaponTrait.InvalidReason>>> getInvalidTraits() {
        return this.invalidTraits;
    }

    public Optional<WeaponTrait> getActionTrait() {
        return this.actionTrait;
    }

    public WeaponType getType() {
        return this.type;
    }

    public void addTagErrorTooltip(ItemStack stack, List<Component> tooltip) {
        if (!this.isValidTag) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.trait.invalid.archetype_tag", "spartanweaponry"), (Object[])new Object[]{this.name, this.traitsTag.f_203868_()}).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public void addTraitsToTooltip(ItemStack stack, List<Component> tooltip, boolean isShiftPressed) {
        this.getTraits().forEach(trait -> trait.addTooltip(stack, tooltip, isShiftPressed, WeaponTrait.InvalidReason.NONE));
        if (this.invalidTraits.isPresent()) {
            this.invalidTraits.get().forEach(traitPair -> ((WeaponTrait)traitPair.getLeft()).addTooltip(stack, tooltip, isShiftPressed, (WeaponTrait.InvalidReason)((Object)((Object)traitPair.getRight()))));
        }
    }

    public double getAttackSpeed() {
        return this.speedValue.get();
    }

    public float getBaseDamage() {
        return this.baseDamage.get().floatValue();
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier.get().floatValue();
    }
}

