/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.transporter;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.povstalec.sgjourney.common.block_entities.transporter.RingPanelEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.menu.RingPanelMenu;

public class RingPanelBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)13.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);

    public RingPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RingPanelEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!level.m_5776_()) {
            final BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RingPanelEntity) {
                RingPanelEntity panel = (RingPanelEntity)blockEntity;
                panel.setTransportRings();
                panel.getNearest6Rings((ServerLevel)level, pos, 32768.0);
                MenuProvider containerProvider = new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"screen.sgjourney.transport_rings");
                    }

                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new RingPanelMenu(windowId, playerInventory, blockEntity);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)blockEntity.m_58899_());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof RingPanelEntity && !level.m_5776_() && !player.m_7500_()) {
            ItemStack itemstack = new ItemStack((ItemLike)BlockInit.RING_PANEL.get());
            blockentity.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{f_54117_});
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = reader.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)reader, blockpos, direction);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }
}

