/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class SGJourneyEnergy
implements IEnergyStorage,
INBTSerializable<Tag> {
    public static final char[] PREFIXES = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y', 'R', 'Q'};
    protected long energy = 0L;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;

    public SGJourneyEnergy(long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return SGJourneyEnergy.regularEnergy(this.receiveLongEnergy(maxReceive, simulate));
    }

    public long receiveLongEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.getTrueMaxEnergyStored() - this.energy, Math.min(this.maxReceive(), maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        if (energyReceived != 0L) {
            this.onEnergyChanged(energyReceived, simulate);
        }
        return energyReceived;
    }

    public long receiveZeroPointEnergy(long maxReceive, boolean simulate) {
        return this.receiveLongEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return SGJourneyEnergy.regularEnergy(this.extractLongEnergy(maxExtract, simulate));
    }

    public long extractLongEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract(), maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        if (energyExtracted != 0L) {
            this.onEnergyChanged(energyExtracted, simulate);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return SGJourneyEnergy.regularEnergy(this.getTrueEnergyStored());
    }

    public long getTrueEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return SGJourneyEnergy.regularEnergy(this.getTrueMaxEnergyStored());
    }

    public long getTrueMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract() > 0L;
    }

    public boolean canReceive() {
        return this.maxReceive() > 0L && this.energy < this.getTrueMaxEnergyStored();
    }

    public boolean canReceive(long receivedEnergy) {
        return this.energy + receivedEnergy <= this.getTrueMaxEnergyStored();
    }

    public long setEnergy(long energy) {
        this.energy = energy;
        return energy;
    }

    public abstract void onEnergyChanged(long var1, boolean var3);

    public long maxReceive() {
        return this.maxReceive;
    }

    public long maxExtract() {
        return this.maxExtract;
    }

    public Tag serializeNBT() {
        return LongTag.m_128882_((long)this.energy);
    }

    public void deserializeNBT(Tag nbt) {
        if (!(nbt instanceof LongTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        LongTag longTag = (LongTag)nbt;
        this.setEnergy(longTag.m_7046_());
    }

    public static int regularEnergy(long energy) {
        return (int)Math.min(Integer.MAX_VALUE, energy);
    }

    public static String energyToString(long energy) {
        int prefix;
        if (energy < 0L) {
            return "NaN";
        }
        if (energy < 1000L) {
            return energy + " FE";
        }
        double total = energy;
        for (prefix = -1; total >= 1000.0 && prefix < PREFIXES.length; total /= 1000.0, ++prefix) {
        }
        total *= 100.0;
        total = Math.floor(total);
        return (total /= 100.0) + " " + PREFIXES[prefix] + "FE";
    }

    public static String energyToString(long energy, long capacity) {
        return SGJourneyEnergy.energyToString(energy) + "/" + SGJourneyEnergy.energyToString(capacity);
    }

    public static long energyToTarget(long energyTarget, long energyStored, long maxExtract) {
        long needed = energyTarget - energyStored;
        if (needed < 0L) {
            return 0L;
        }
        return Math.min(needed, maxExtract);
    }
}

