/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class Conversion {
    public static final ResourceLocation DIMENSION_LOCATION = new ResourceLocation("minecraft", "dimension");
    public static final ResourceKey<Registry<Level>> DIMENSION_KEY = ResourceKey.m_135788_((ResourceLocation)DIMENSION_LOCATION);

    @Nullable
    public static ResourceKey<Level> locationToDimension(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(DIMENSION_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Level> stringToDimension(String dimensionString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)dimensionString);
        if (location != null) {
            return Conversion.locationToDimension(location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<PointOfOrigin> locationToPointOfOrigin(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(PointOfOrigin.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<PointOfOrigin> stringToPointOfOrigin(String pointOfOriginString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)pointOfOriginString);
        return Conversion.locationToPointOfOrigin(location);
    }

    @Nullable
    public static ResourceKey<Symbols> locationToSymbols(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(Symbols.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Symbols> stringToSymbols(String symbolsString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)symbolsString);
        return Conversion.locationToSymbols(location);
    }

    @Nullable
    public static ResourceKey<Galaxy> locationToGalaxyKey(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(Galaxy.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Galaxy> stringToGalaxyKey(String galaxyString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)galaxyString);
        return Conversion.locationToGalaxyKey(location);
    }

    @Nullable
    public static ResourceKey<SolarSystem> locationToSolarSystemKey(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(SolarSystem.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<SolarSystem> stringToSolarSystemKey(String solarSystemString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)solarSystemString);
        return Conversion.locationToSolarSystemKey(location);
    }

    public static Vec3i intArrayToVec(int[] coordinates) {
        if (coordinates.length == 3) {
            return new Vec3i(coordinates[0], coordinates[1], coordinates[2]);
        }
        return null;
    }

    public static BlockPos intArrayToBlockPos(int[] coordinates) {
        Vec3i vec3i = Conversion.intArrayToVec(coordinates);
        if (vec3i != null) {
            return new BlockPos(vec3i);
        }
        return null;
    }

    public static int[] vecToIntArray(Vec3i coordinates) {
        return new int[]{coordinates.m_123341_(), coordinates.m_123342_(), coordinates.m_123343_()};
    }

    public static int[] blockPosToIntArray(BlockPos coordinates) {
        return Conversion.vecToIntArray((Vec3i)coordinates);
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static String secondsToString(int seconds) {
        int s = seconds % 60;
        int m = seconds / 60;
        int h = m / 60;
        String result = s + "s";
        if ((m %= 60) > 0) {
            result = m + "m " + result;
        }
        if (h > 0) {
            result = h + "h " + result;
        }
        return result;
    }

    public static String ticksToString(int ticks) {
        return Conversion.secondsToString(Conversion.ticksToSeconds(ticks));
    }
}

