/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.blockstates.Orientation;

public class CoordinateHelper {

    public static class Relative {
        public static double projectVectorToScalar(Vec3 a, Vec3 b) {
            return a.m_82526_(b) / b.m_82526_(b);
        }

        public static Vec3 projectVector(Vec3 a, Vec3 b) {
            double scalar = Relative.projectVectorToScalar(a, b);
            return b.m_82542_(scalar, scalar, scalar);
        }

        public static Vec3 fromOrthogonalBasis(Vec3 vector, Vec3 basisX, Vec3 basisY, Vec3 basisZ) {
            double xProj = Relative.projectVectorToScalar(vector, basisX);
            double yProj = Relative.projectVectorToScalar(vector, basisY);
            double zProj = Relative.projectVectorToScalar(vector, basisZ);
            return new Vec3(xProj, yProj, zProj);
        }

        public static Vec3 toOrthogonalBasis(Vec3 vector, Vec3 basisX, Vec3 basisY, Vec3 basisZ) {
            return new Vec3(vector.m_7096_() * basisX.m_7096_() + vector.m_7098_() * basisY.m_7096_() + vector.m_7094_() * basisZ.m_7096_(), vector.m_7096_() * basisX.m_7098_() + vector.m_7098_() * basisY.m_7098_() + vector.m_7094_() * basisZ.m_7098_(), vector.m_7096_() * basisX.m_7094_() + vector.m_7098_() * basisY.m_7094_() + vector.m_7094_() * basisZ.m_7094_());
        }

        public static Vec3 vecRight(Vec3 forward, Vec3 up) {
            return forward.m_82537_(up);
        }

        public static Vec3 mirrorVector(Vec3 vector) {
            return vector.m_82542_(-1.0, -1.0, -1.0);
        }

        public static Vec3 rotateVector(Vec3 initialVector, Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation) {
            Vec3 initialForward = Orientation.getForwardVector(initialDirection, initialOrientation);
            Vec3 initialUp = Orientation.getUpVector(initialDirection, initialOrientation);
            Vec3 destinationForward = Orientation.getForwardVector(destinationDirection, destinationOrientation);
            Vec3 destinationUp = Orientation.getUpVector(destinationDirection, destinationOrientation);
            return Relative.rotateVector(initialVector, initialForward, initialUp, destinationForward, destinationUp);
        }

        public static Vec3 rotateVector(Vec3 initialVector, Vec3 initialForward, Vec3 initialUp, Vec3 destinationForward, Vec3 destinationUp) {
            Vec3 initialRight = initialForward.m_82537_(initialUp);
            Vec3 inbetweenVector = Relative.fromOrthogonalBasis(initialVector, initialForward, initialUp, initialRight);
            Vec3 destinationRight = destinationForward.m_82537_(destinationUp);
            Vec3 destinationVector = Relative.toOrthogonalBasis(inbetweenVector, destinationForward.m_82542_(-1.0, -1.0, -1.0), destinationUp, destinationRight.m_82542_(-1.0, -1.0, -1.0));
            return destinationVector;
        }

        public static Vec3 preserveRelative(Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation, Vec3 initial) {
            return Relative.rotateVector(initial, initialDirection, initialOrientation, destinationDirection, destinationOrientation);
        }

        public static float preserveYRot(Direction initialDirection, Direction destinationDirection, float yRot) {
            float initialStargateDirection = Mth.m_14177_((float)initialDirection.m_122435_());
            float destinationStargateDirection = Mth.m_14177_((float)destinationDirection.m_122435_());
            float relativeRot = destinationStargateDirection - initialStargateDirection;
            yRot = yRot + relativeRot + 180.0f;
            return yRot;
        }

        public static Vec3i yRotateClockwise(Vec3i vector, int numberOfRotations) {
            int x = vector.m_123341_();
            int z = vector.m_123343_();
            for (int i = 0; i < numberOfRotations; ++i) {
                int helper = x;
                x = -z;
                z = helper;
            }
            return new Vec3i(x, vector.m_123342_(), z);
        }

        public static long distanceSqr(Vec3i posA, Vec3i posB) {
            if (posA == null || posB == null) {
                return Long.MAX_VALUE;
            }
            long x = posB.m_123341_() - posA.m_123341_();
            long y = posB.m_123342_() - posA.m_123342_();
            long z = posB.m_123343_() - posA.m_123343_();
            return x * x + y * y + z * z;
        }

        public static double distance(Vec3i posA, Vec3i posB) {
            if (posA == null || posB == null) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.sqrt(Relative.distanceSqr(posA, posB));
        }

        public static Vec3i blockPosOffset(BlockPos initialPos, BlockPos otherPos) {
            return new Vec3i(otherPos.m_123341_() - initialPos.m_123341_(), otherPos.m_123342_() - initialPos.m_123342_(), otherPos.m_123343_() - initialPos.m_123343_());
        }

        public static Vec3i getRelativeOffset(Direction initialDirection, BlockPos initialPos, BlockPos otherPos) {
            int initialRotation = initialDirection.m_122416_();
            int rotation = -initialRotation;
            if (rotation < 0) {
                rotation += 4;
            }
            Vec3i absoluteOffset = Relative.blockPosOffset(initialPos, otherPos);
            return Relative.yRotateClockwise(absoluteOffset, rotation);
        }

        public static Vec3i getAbsoluteOffset(Direction initialDirection, Vec3i relativeOffset) {
            if (initialDirection == null) {
                return null;
            }
            int destinationRotation = initialDirection.m_122416_();
            int rotation = destinationRotation;
            if (rotation < 0) {
                rotation += 4;
            }
            return Relative.yRotateClockwise(relativeOffset, rotation);
        }

        public static BlockPos getOffsetPos(Direction initialDirection, BlockPos initialPos, Vec3i relativeOffset) {
            Vec3i absoluteOffset = Relative.getAbsoluteOffset(initialDirection, relativeOffset);
            if (absoluteOffset == null) {
                return null;
            }
            return initialPos.m_121955_(absoluteOffset);
        }
    }

    public static class CoordinateSystems {
        public static float cartesianToPolarR(float x, float y) {
            return (float)Math.sqrt(x * x + y * y);
        }

        public static float cartesianToPolarPhi(float x, float y) {
            return (float)Math.toDegrees(Math.atan2(y, x));
        }

        public static float polarToCartesianX(float r, float phi) {
            return r * (float)Math.cos(Math.toRadians(phi));
        }

        public static float polarToCartesianY(float r, float phi) {
            return r * (float)Math.sin(Math.toRadians(phi));
        }

        public static float lookAngleY(Vec3 lookAngle) {
            return CoordinateSystems.cartesianToPolarPhi((float)lookAngle.m_7096_(), (float)lookAngle.m_7094_()) + 270.0f;
        }
    }
}

