/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.povstalec.sgjourney.common.block_entities.tech.TransceiverEntity;

public class ServerboundTransceiverUpdatePacket {
    public final BlockPos pos;
    public final boolean remove;
    public final boolean toggleFrequency;
    public final int number;
    public final boolean transmit;

    public ServerboundTransceiverUpdatePacket(BlockPos pos, boolean remove, boolean toggleFrequency, int number, boolean transmit) {
        this.pos = pos;
        this.remove = remove;
        this.toggleFrequency = toggleFrequency;
        this.number = number;
        this.transmit = transmit;
    }

    public ServerboundTransceiverUpdatePacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.readBoolean(), buffer.readBoolean(), buffer.readInt(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.remove);
        buffer.writeBoolean(this.toggleFrequency);
        buffer.writeInt(this.number);
        buffer.writeBoolean(this.transmit);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_7702_(this.pos);
            if (blockEntity instanceof TransceiverEntity) {
                TransceiverEntity transceiver = (TransceiverEntity)blockEntity;
                if (this.transmit) {
                    transceiver.sendTransmission();
                } else if (this.toggleFrequency) {
                    transceiver.toggleFrequency();
                } else if (this.remove) {
                    transceiver.removeFromCode();
                } else {
                    transceiver.addToCode(this.number);
                }
            }
        });
        return true;
    }
}

