/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.TransporterConnection;
import net.povstalec.sgjourney.common.sgjourney.Wormhole;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class Transporting {
    public static void startTransport(MinecraftServer server, Transporter initialTransporter, UUID targetUUID) {
        Transporter targetTransporter = TransporterNetwork.get(server).getTransporter(targetUUID);
        TransporterNetwork.get(server).createConnection(server, initialTransporter, targetTransporter);
    }

    public static boolean transportTraveler(MinecraftServer server, TransporterConnection connection, Transporter initialTransporter, Transporter receivingTransporter, Entity traveler) {
        Vec3 relativePosition = initialTransporter.toTransporterCoords(server, traveler.m_20182_().m_82546_(initialTransporter.transportPos(server)), true);
        Vec3 relativeMomentum = initialTransporter.toTransporterCoords(server, traveler.m_20184_(), false);
        Vec3 relativeLookAngle = initialTransporter.toTransporterCoords(server, traveler.m_20154_(), false);
        return relativePosition.m_82556_() <= initialTransporter.getInnerRadius() * initialTransporter.getInnerRadius() && receivingTransporter.receiveTraveler(server, connection, initialTransporter, traveler, relativePosition, relativeMomentum, relativeLookAngle);
    }

    public static boolean transportTravelers(MinecraftServer server, TransporterConnection connection, Transporter initialTransporter, Transporter receivingTransporter, List<Entity> travelers) {
        boolean used = false;
        for (Entity traveler : travelers) {
            if (!Transporting.transportTraveler(server, connection, initialTransporter, receivingTransporter, traveler)) continue;
            used = true;
        }
        return used;
    }

    public static Entity transportEntity(ServerLevel destinationLevel, Transporter receivingTransporter, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        if (traveler.m_9236_() != destinationLevel) {
            traveler = traveler.changeDimension(destinationLevel, (ITeleporter)new Wormhole.WormholeTeleporter(destinationPosition, destinationMomentum, CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.m_146909_()));
        } else {
            traveler.m_7678_(destinationPosition.m_7096_(), destinationPosition.m_7098_(), destinationPosition.m_7094_(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), traveler.m_146909_());
            traveler.m_20256_(destinationMomentum);
        }
        return traveler;
    }

    public static Entity transportPlayer(ServerLevel destinationLevel, Transporter receivingTransporter, ServerPlayer player, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        player.m_8999_(destinationLevel, destinationPosition.m_7096_(), destinationPosition.m_7098_(), destinationPosition.m_7094_(), CoordinateHelper.CoordinateSystems.lookAngleY(destinationLookAngle), player.m_146909_());
        player.m_20256_(destinationMomentum);
        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
        return player;
    }

    public static Entity recursivePassengerTeleport(ServerLevel destinationLevel, Transporter receivingTransporter, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Level initialLevel = traveler.m_9236_();
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        if (initialLevel != destinationLevel) {
            for (Entity passenger : traveler.m_20197_()) {
                passengers.add(Transporting.recursivePassengerTeleport(destinationLevel, receivingTransporter, passenger, destinationPosition, destinationMomentum, destinationLookAngle));
            }
        }
        if (traveler instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)traveler;
            traveler = Transporting.transportPlayer(destinationLevel, receivingTransporter, player, destinationPosition, destinationMomentum, destinationLookAngle);
        } else {
            traveler = Transporting.transportEntity(destinationLevel, receivingTransporter, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        }
        if (initialLevel != destinationLevel) {
            for (Entity passenger : passengers) {
                passenger.m_7998_(traveler, true);
            }
        }
        return traveler;
    }

    public static boolean receiveTraveler(ServerLevel level, Transporter receivingTransporter, Entity traveler, Vec3 destinationPosition, Vec3 destinationMomentum, Vec3 destinationLookAngle) {
        Transporting.recursivePassengerTeleport(level, receivingTransporter, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        return true;
    }
}

