/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.whistle;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorCarriage;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRSounds;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConductorWhistleItem
extends TrackTargetingBlockItem {
    public static final String SPECIAL_MARKER = "<ConductorFlag>";

    public ConductorWhistleItem(Block block, Item.Properties properties) {
        super(block, properties, EdgePointType.STATION);
    }

    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        return false;
    }

    private static InteractionResult fail(Player player, String message) {
        player.m_5661_((Component)Component.m_237115_((String)("railways.whistle.failure." + message)).m_130940_(ChatFormatting.RED), true);
        player.m_5661_((Component)Component.m_237115_((String)("railways.whistle.failure." + message)).m_130940_(ChatFormatting.RED), false);
        return InteractionResult.FAIL;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_("SelectedTrain") && tag.m_128403_("SelectedConductor")) {
            UUID trainId = tag.m_128342_("SelectedTrain");
            UUID conductorId = tag.m_128342_("SelectedConductor");
            String trainName = "NOT FOUND";
            GlobalRailwayManager railways = Create.RAILWAYS.sided((LevelAccessor)level);
            if (railways != null && railways.trains.containsKey(trainId)) {
                trainName = ((Train)railways.trains.get((Object)trainId)).name.getString();
            }
            tooltip.add((Component)Component.m_237115_((String)"railways.whistle.tool.bound").m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.conductor_id", conductorId.toString().substring(0, 5)));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.train_id", trainName, trainId.toString().substring(0, 5)));
            tooltip.add((Component)Component.m_237115_((String)"railways.whistle.tool.bound_usage"));
            tooltip.add((Component)Component.m_237115_((String)"railways.whistle.tool.bound_auto_usage"));
            tooltip.add((Component)Component.m_237115_((String)"railways.whistle.tool.bound_auto_clear"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"railways.whistle.tool.not_bound").m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ConductorEntity conductor;
        Entity entity;
        if (pPlayer.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        if (pInteractionTarget instanceof ConductorEntity && (entity = (conductor = (ConductorEntity)pInteractionTarget).m_20202_()) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Train train = cce.getCarriage().train;
            if (train.owner == pPlayer.m_20148_() || !((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue()) {
                CompoundTag stackTag = pStack.m_41784_();
                stackTag.m_128362_("SelectedTrain", train.id);
                stackTag.m_128362_("SelectedConductor", conductor.m_20148_());
                stackTag.m_128344_("SelectedColor", ((Byte)conductor.m_20088_().m_135370_(ConductorEntity.COLOR)).byteValue());
                pPlayer.m_5661_((Component)Component.m_237115_((String)"railways.whistle.set"), true);
                pStack.m_41751_(stackTag);
                pPlayer.m_21008_(pUsedHand, pStack);
                AllSoundEvents.PECULIAR_BELL_USE.play(pPlayer.f_19853_, null, conductor.m_20185_(), conductor.m_20186_(), conductor.m_20189_(), 0.5f, 1.1f);
                return InteractionResult.SUCCESS;
            }
            pPlayer.m_5661_((Component)Component.m_237115_((String)"railways.whistle.not_owner").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag == null) {
            return InteractionResult.FAIL;
        }
        UUID trainId = stackTag.m_128342_("SelectedTrain");
        Train train = (Train)Create.RAILWAYS.trains.get(trainId);
        if (player == null || train == null) {
            return InteractionResult.FAIL;
        }
        if (player instanceof DeployerFakePlayer && state.m_60734_() instanceof AirBlock && train.runtime.isAutoSchedule) {
            train.runtime.discardSchedule();
        }
        if (player.m_20161_() && stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"railways.whistle.clear"), true);
            stack.m_41751_(null);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() instanceof StationBlock || state.m_60734_() instanceof ITrackBlock) {
            ItemStack scheduleStack;
            level.m_5594_(null, pos, (SoundEvent)CRSounds.CONDUCTOR_WHISTLE.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Object stationName = "";
            if (!stackTag.m_128403_("SelectedTrain") || !stackTag.m_128403_("SelectedConductor")) {
                return ConductorWhistleItem.fail(player, "not_bound");
            }
            UUID conductorId = stackTag.m_128342_("SelectedConductor");
            if (!Create.RAILWAYS.trains.containsKey(trainId)) {
                return ConductorWhistleItem.fail(player, "train_missing");
            }
            boolean foundConductor = false;
            Carriage conductorCarriage = null;
            for (Carriage carriage : train.carriages) {
                if (!((ICarriageConductors)carriage).railways$getControllingConductors().contains(conductorId)) continue;
                foundConductor = true;
                conductorCarriage = carriage;
                break;
            }
            if (!foundConductor) {
                return ConductorWhistleItem.fail(player, "conductor_missing");
            }
            Block block = state.m_60734_();
            if (block instanceof ITrackBlock) {
                ITrackBlock track = (ITrackBlock)block;
                lookAngle = player.m_20154_();
                boolean front = track.getNearestTrackAxis((BlockGetter)level, pos, state, (Vec3)lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
                stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                stackTag.m_128379_("SelectedDirection", front);
                stackTag.m_128473_("Bezier");
                stack.m_41751_(stackTag);
                EdgePointType type = this.getType(stack);
                MutableObject result = new MutableObject(null);
                ConductorWhistleItem.withGraphLocation((Level)level, (BlockPos)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
                if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                    player.m_5661_((Component)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
                    AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                    return InteractionResult.FAIL;
                }
                Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
                Direction successDirection = null;
                for (Direction direction : directions) {
                    BlockPos placePos = pos.m_121945_(direction);
                    Vec3 hitPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5).m_82520_((double)direction.m_122429_() * 0.5, (double)direction.m_122430_() * 0.5, (double)direction.m_122431_() * 0.5);
                    BlockPlaceContext ctx = new BlockPlaceContext(player, pContext.m_43724_(), stack, new BlockHitResult(hitPos, direction.m_122424_(), placePos, false));
                    if (!level.m_8055_(placePos).m_60629_(ctx)) continue;
                    successDirection = direction;
                    break;
                }
                if (successDirection == null) {
                    stackTag.m_128473_("SelectedPos");
                    stackTag.m_128473_("SelectedDirection");
                    stack.m_41751_(stackTag);
                    return ConductorWhistleItem.fail(player, "no_space");
                }
                BlockPos placePos = pos.m_121945_(successDirection);
                stationName = SPECIAL_MARKER + placePos.m_123344_();
                BlockState placeState = CRBlocks.CONDUCTOR_WHISTLE_FLAG.getDefaultState();
                level.m_7731_(placePos, placeState, 11);
                CompoundTag teTag = new CompoundTag();
                teTag.m_128359_("Name", (String)stationName);
                teTag.m_128344_("SelectedColor", stackTag.m_128445_("SelectedColor"));
                teTag.m_128379_("TargetDirection", stackTag.m_128471_("SelectedDirection"));
                BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)stackTag.m_128469_("SelectedPos"));
                teTag.m_128365_("TargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)selectedPos.m_121996_((Vec3i)placePos)));
                stackTag.m_128365_("BlockEntityTag", (Tag)teTag);
                stack.m_41751_(stackTag);
                this.m_7274_(placePos, level, player, stack, placeState);
                stackTag.m_128473_("SelectedPos");
                stackTag.m_128473_("SelectedDirection");
                stackTag.m_128473_("BlockEntityTag");
                stack.m_41751_(stackTag);
            } else {
                lookAngle = level.m_7702_(pos);
                if (lookAngle instanceof StationBlockEntity) {
                    StationBlockEntity stationBe = (StationBlockEntity)lookAngle;
                    stationName = Objects.requireNonNull(stationBe.getStation()).name;
                }
            }
            if (((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != player) {
                stackTag.m_128473_("SelectedPos");
                stackTag.m_128473_("SelectedDirection");
                stack.m_41751_(stackTag);
                return ConductorWhistleItem.fail(player, "not_owner");
            }
            if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !(scheduleStack = train.runtime.returnSchedule()).m_41619_()) {
                for (CompoundTag passengerTag : ((AccessorCarriage)conductorCarriage).getSerialisedPassengers().values()) {
                    ListTag schedulesList;
                    if (passengerTag.m_128441_("PlayerPassenger") || !passengerTag.m_128441_("id") || !CREntities.CONDUCTOR.getId().equals((Object)new ResourceLocation(passengerTag.m_128461_("id"))) || !passengerTag.m_128403_("UUID") || !passengerTag.m_128342_("UUID").equals(conductorId)) continue;
                    if (!passengerTag.m_128441_("heldSchedules")) {
                        schedulesList = new ListTag();
                        passengerTag.m_128365_("heldSchedules", (Tag)schedulesList);
                    } else {
                        schedulesList = passengerTag.m_128437_("heldSchedules", 10);
                    }
                    schedulesList.add((Object)scheduleStack.m_41739_(new CompoundTag()));
                    scheduleStack.m_41764_(0);
                    break;
                }
                if (!scheduleStack.m_41619_()) {
                    conductorCarriage.forEachPresentEntity(cce -> {
                        if (!scheduleStack.m_41619_()) {
                            for (Entity passenger : cce.m_20197_()) {
                                if (!(passenger instanceof ConductorEntity)) continue;
                                ConductorEntity conductorEntity = (ConductorEntity)passenger;
                                if (!passenger.m_20148_().equals(conductorId)) continue;
                                conductorEntity.addSchedule(scheduleStack);
                                scheduleStack.m_41764_(0);
                                break;
                            }
                        }
                    });
                }
                if (!scheduleStack.m_41619_() && !player.m_36356_(scheduleStack)) {
                    player.m_36176_(scheduleStack, false);
                }
            }
            player.m_5661_((Component)Component.m_237115_((String)"railways.whistle.success"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 1.0f);
            Schedule schedule = new Schedule();
            ScheduleEntry entry = new ScheduleEntry();
            DestinationInstruction instruction = new DestinationInstruction();
            ScheduledDelay condition = new ScheduledDelay();
            condition.getData().m_128405_("Value", 0);
            instruction.getData().m_128359_("Text", (String)stationName);
            entry.instruction = instruction;
            if (entry.conditions.isEmpty()) {
                entry.conditions.add(new ArrayList());
            }
            ((List)entry.conditions.get(0)).add(condition);
            schedule.entries.add(entry);
            schedule.cyclic = false;
            train.runtime.discardSchedule();
            train.runtime.setSchedule(schedule, true);
            ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag;
        ServerLevel serverLevel;
        if (isSelected && level instanceof ServerLevel && ((serverLevel = (ServerLevel)level).m_46467_() + (long)entity.hashCode() + (long)slotId) % (long)((Integer)CRConfigs.server().conductors.whistleRebindRate.get()).intValue() == 0L && (tag = stack.m_41783_()) != null && tag.m_128403_("SelectedTrain") && tag.m_128403_("SelectedConductor")) {
            ConductorEntity conductor;
            Entity entity2;
            UUID trainId = tag.m_128342_("SelectedTrain");
            UUID conductorId = tag.m_128342_("SelectedConductor");
            Entity entity3 = serverLevel.m_8791_(conductorId);
            if (entity3 instanceof ConductorEntity && (entity2 = (conductor = (ConductorEntity)entity3).m_20202_()) instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)entity2;
                if (!trainId.equals(cce.trainId)) {
                    tag.m_128362_("SelectedTrain", cce.trainId);
                }
            }
        }
    }
}

