/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.google.common.collect.Maps;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfig;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacketHandler;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PlayerBoolConfigMessage(String uuid, String key, boolean value) implements ChameleonPacket<PlayerBoolConfigMessage>
{
    public static final ResourceLocation ID = new ResourceLocation("storagedrawers", "player_bool_config");
    public static final Handler HANDLER = new Handler();

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ChameleonPacketHandler<PlayerBoolConfigMessage> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements ChameleonPacketHandler<PlayerBoolConfigMessage> {
        private Handler() {
        }

        @Override
        public Class<PlayerBoolConfigMessage> type() {
            return PlayerBoolConfigMessage.class;
        }

        @Override
        public void encode(PlayerBoolConfigMessage message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.uuid);
            buffer.m_130070_(message.key);
            buffer.writeBoolean(message.value);
        }

        @Override
        public PlayerBoolConfigMessage decode(FriendlyByteBuf buffer) {
            String uuid = buffer.m_130277_();
            String key = buffer.m_130277_();
            boolean value = buffer.readBoolean();
            return new PlayerBoolConfigMessage(uuid, key, value);
        }

        @Override
        public void handle(PlayerBoolConfigMessage message, Player player, Consumer<Runnable> workQueue) {
            if (player instanceof ServerPlayer) {
                workQueue.accept(() -> {
                    UUID playerUniqueId;
                    try {
                        playerUniqueId = UUID.fromString(message.uuid);
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                    HashMap clientMap = PlayerConfig.serverPlayerConfigSettings.get(playerUniqueId);
                    if (clientMap == null) {
                        clientMap = Maps.newHashMap();
                    }
                    clientMap.put(message.key, new PlayerConfigSetting<Boolean>(message.key, message.value, playerUniqueId));
                    PlayerConfig.serverPlayerConfigSettings.put(playerUniqueId, clientMap);
                });
            }
        }
    }
}

