/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data;

import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;

public abstract class GenericTextureGenerator
extends GenericDataProvider {
    @Nullable
    protected final ExistingFileHelper existingFileHelper;
    @Nullable
    private final ExistingFileHelper.ResourceType resourceType;

    public GenericTextureGenerator(PackOutput packOutput, @Nullable ExistingFileHelper existingFileHelper, String folder) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, folder);
        this.existingFileHelper = existingFileHelper;
        this.resourceType = existingFileHelper != null ? new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", folder) : null;
    }

    public GenericTextureGenerator(PackOutput packOutput, String folder) {
        this(packOutput, null, folder);
    }

    protected CompletableFuture<?> saveImage(CachedOutput cache, ResourceLocation location, NativeImage image) {
        if (this.existingFileHelper != null && this.resourceType != null) {
            this.existingFileHelper.trackGenerated(location, (ExistingFileHelper.IResourceType)this.resourceType);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                Path path = this.pathProvider.m_245527_(location, "png");
                byte[] bytes = image.m_85121_();
                cache.m_213871_(path, bytes, Hashing.sha1().hashBytes(bytes));
            }
            catch (IOException e) {
                TConstruct.LOG.error("Couldn't write image for {}", (Object)location, (Object)e);
                throw new CompletionException(e);
            }
        }, Util.m_183991_());
    }

    protected CompletableFuture<?> saveMetadata(CachedOutput cache, ResourceLocation location, JsonObject metadata) {
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)metadata, (Path)this.pathProvider.m_245527_(location, "png.mcmeta"));
    }
}

