/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class TankModifierModel
extends FluidModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(ToolTankHelper.TANK_HELPER);

    public TankModifierModel(ToolTankHelper helper, @Nullable Material smallTexture, @Nullable Material largeTexture, @Nullable Material smallPartial, @Nullable Material largePartial, @Nullable Material smallFull, @Nullable Material largeFull) {
        super(helper, smallTexture, largeTexture, new Material[]{smallPartial, largePartial, smallFull != null ? smallFull : smallPartial, largeFull != null ? largeFull : largePartial});
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        FluidStack fluid = this.helper.getFluid(tool);
        if (!fluid.isEmpty()) {
            return new TankModifierCacheKey(entry.getModifier(), fluid.getFluid(), fluid.getAmount() < this.helper.getCapacity(tool));
        }
        return entry != ModifierEntry.EMPTY ? entry.getId() : null;
    }

    @Override
    @Nullable
    protected Material getTemplate(IToolStackView tool, ModifierEntry entry, FluidStack fluid, boolean isLarge) {
        boolean isFull = fluid.getAmount() == this.helper.getCapacity(tool);
        return this.fluidTextures[(isFull ? 2 : 0) | (isLarge ? 1 : 0)];
    }

    private record TankModifierCacheKey(Modifier modifier, Fluid fluid, boolean isPartial) {
    }

    public record Unbaked(ToolTankHelper helper) implements IUnbakedModifierModel
    {
        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, Material> smallGetter, Function<String, Material> largeGetter) {
            Material smallTexture = smallGetter.apply("");
            Material largeTexture = largeGetter.apply("");
            Material smallPartial = smallGetter.apply("_partial");
            Material largePartial = largeGetter.apply("_partial");
            Material smallFull = smallGetter.apply("_full");
            Material largeFull = largeGetter.apply("_full");
            if (smallTexture != null || largeTexture != null || smallPartial != null || largePartial != null || smallFull != null || largeFull != null) {
                return new TankModifierModel(this.helper, smallTexture, largeTexture, smallPartial, largePartial, smallFull, largeFull);
            }
            return null;
        }
    }
}

