/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.impl.ComposableModifier;
import slimeknights.tconstruct.library.modifiers.util.DynamicModifier;

public abstract class AbstractModifierProvider
extends GenericDataProvider {
    private final Map<ModifierId, Composable> composableModifiers = new HashMap<ModifierId, Composable>();

    public AbstractModifierProvider(PackOutput packOutput) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/modifiers", ModifierManager.GSON);
    }

    protected abstract void addModifiers();

    private void addBuilder(ModifierId id, @Nullable ComposableModifier.Builder builder, @Nullable ICondition condition, JsonRedirect ... redirects) {
        Composable previous = this.composableModifiers.putIfAbsent(id, new Composable(builder, condition, redirects));
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate modifier " + id);
        }
    }

    protected ComposableModifier.Builder buildModifier(ModifierId id, @Nullable ICondition condition, JsonRedirect ... redirects) {
        ComposableModifier.Builder builder = ComposableModifier.builder();
        this.addBuilder(id, builder, condition, redirects);
        return builder;
    }

    protected ComposableModifier.Builder buildModifier(ModifierId id, JsonRedirect ... redirects) {
        return this.buildModifier(id, (ICondition)null, redirects);
    }

    protected ComposableModifier.Builder buildModifier(DynamicModifier modifier, @Nullable ICondition condition, JsonRedirect ... redirects) {
        return this.buildModifier(modifier.getId(), condition, redirects);
    }

    protected ComposableModifier.Builder buildModifier(DynamicModifier modifier, JsonRedirect ... redirects) {
        return this.buildModifier(modifier, (ICondition)null, redirects);
    }

    protected void addRedirect(ModifierId id, @Nullable ICondition condition, JsonRedirect ... redirects) {
        this.addBuilder(id, null, condition, redirects);
    }

    protected void addRedirect(ModifierId id, JsonRedirect ... redirects) {
        this.addRedirect(id, (ICondition)null, redirects);
    }

    protected JsonRedirect conditionalRedirect(ModifierId id, @Nullable ICondition condition) {
        return new JsonRedirect(id, condition);
    }

    protected JsonRedirect redirect(ModifierId id) {
        return this.conditionalRedirect(id, null);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addModifiers();
        return AbstractModifierProvider.allOf(this.composableModifiers.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((Composable)entry.getValue()).serialize())));
    }

    private record Composable(@Nullable ComposableModifier.Builder builder, @Nullable ICondition condition, JsonRedirect[] redirects) {
        public JsonObject serialize() {
            JsonObject json = this.builder != null ? ComposableModifier.LOADER.serialize((Object)this.builder.build()).getAsJsonObject() : new JsonObject();
            if (this.redirects.length != 0) {
                JsonArray array = new JsonArray();
                for (JsonRedirect redirect : this.redirects) {
                    array.add((JsonElement)redirect.toJson());
                }
                json.add("redirects", (JsonElement)array);
            }
            if (this.condition != null) {
                json.add("condition", (JsonElement)CraftingHelper.serialize((ICondition)this.condition));
            }
            return json;
        }
    }
}

