/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.AbstractMaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialCastingRecipe
extends AbstractMaterialCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    protected static final LoadableField<IMaterialItem, MaterialCastingRecipe> RESULT_FIELD = TinkerLoadables.MATERIAL_ITEM.requiredField("result", r -> r.result);
    public static final RecordLoadable<MaterialCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, (RecordField)ITEM_COST_FIELD, RESULT_FIELD, (RecordField)CAST_CONSUMED_FIELD, (RecordField)SWITCH_SLOTS_FIELD, MaterialCastingRecipe::new);
    protected final IMaterialItem result;
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public MaterialCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
        super(serializer, id, group, cast, itemCost, consumed, switchSlots);
        this.result = result;
        MaterialCastingLookup.registerItemCost(result, itemCost);
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        if (!this.getCast().test(inv.getStack())) {
            return false;
        }
        MaterialFluidRecipe fluid = this.getFluidRecipe(inv);
        return fluid != MaterialFluidRecipe.EMPTY && this.result.canUseMaterial(fluid.getOutput().getId());
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        return this.result.withMaterial(this.getFluidRecipe(inv).getOutput().getVariant());
    }

    public List<IDisplayableCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.multiRecipes == null) {
            RecipeType<?> type = this.m_6671_();
            List<ItemStack> castItems = Arrays.asList(this.getCast().m_43908_());
            this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> {
                MaterialVariant output = recipe.getOutput();
                return !output.isUnknown() && !output.get().isHidden() && this.result.canUseMaterial(output.getId());
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                return new DisplayCastingRecipe(this.m_6423_(), type, castItems, fluids, this.result.withMaterial(recipe.getOutput().getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.isConsumed());
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }
}

