/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BlockSideHitListener {
    private static final Map<UUID, Direction> HIT_FACE = new HashMap<UUID, Direction>();
    private static Direction clientSideHit = Direction.UP;
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(BlockSideHitListener::onLeftClickBlock);
        MinecraftForge.EVENT_BUS.addListener(BlockSideHitListener::onLeaveServer);
    }

    private static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START) {
            Player player = event.getEntity();
            if (player.m_9236_().m_5776_()) {
                clientSideHit = event.getFace();
            } else {
                HIT_FACE.put(player.m_20148_(), event.getFace());
            }
        }
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        HIT_FACE.remove(event.getEntity().m_20148_());
    }

    public static Direction getSideHit(Player player) {
        if (player.m_9236_().m_5776_()) {
            return clientSideHit;
        }
        return HIT_FACE.getOrDefault(player.m_20148_(), Direction.UP);
    }

    public static Direction getClientSideHit() {
        return clientSideHit;
    }
}

