/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.block.entity.InventoryBlockEntity;
import slimeknights.tconstruct.common.SoundUtils;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.network.UpdateStationScreenPacket;

public abstract class TableBlockEntity
extends InventoryBlockEntity {
    private final Map<UUID, Integer> lastSoundTick = new HashMap<UUID, Integer>();

    public TableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, Component name, int inventorySize) {
        super(tileEntityTypeIn, pos, state, name, false, inventorySize);
    }

    public TableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, Component name, int inventorySize, int maxStackSize) {
        super(tileEntityTypeIn, pos, state, name, false, inventorySize, maxStackSize);
    }

    public void m_6836_(int slot, ItemStack itemstack) {
        if (this.f_58857_ != null && this.f_58857_ instanceof ServerLevel && !this.f_58857_.f_46443_ && !ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)this.m_8020_(slot))) {
            TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(itemstack, slot, this.f_58858_), (ServerLevel)this.f_58857_, this.f_58858_);
        }
        super.m_6836_(slot, itemstack);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeInventoryToNBT(nbt);
        return nbt;
    }

    public void syncToRelevantPlayers(Consumer<Player> action) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_6907_().stream().filter(player -> {
            if (player.f_36096_ instanceof TabbedContainerMenu) {
                return ((TabbedContainerMenu)player.f_36096_).getTile() == this;
            }
            return false;
        }).forEach(action);
    }

    protected boolean isSoundReady(Player player) {
        int lastSound = this.lastSoundTick.getOrDefault(player.m_20148_(), 0);
        if (lastSound < player.f_19797_) {
            this.lastSoundTick.put(player.m_20148_(), player.f_19797_);
            return true;
        }
        return false;
    }

    protected void playCraftSound(Player player) {
        if (this.isSoundReady(player)) {
            SoundUtils.playSoundForAll((Entity)player, Sounds.SAW.getSound(), 0.8f, 0.8f + 0.4f * player.m_9236_().f_46441_.m_188501_());
        }
    }

    protected void syncScreen(Player player) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TinkerNetwork.getInstance().sendTo(UpdateStationScreenPacket.INSTANCE, serverPlayer);
        }
    }

    protected void syncScreenToRelevantPlayers() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.syncToRelevantPlayers(this::syncScreen);
        }
    }
}

