/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;

public record GripMaterialStats(float durability, float accuracy, float meleeDamage) implements IMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("grip"));
    public static final MaterialStatType<GripMaterialStats> TYPE = new MaterialStatType<GripMaterialStats>(ID, new GripMaterialStats(0.0f, 0.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("durability", (Object)Float.valueOf(0.0f), true, GripMaterialStats::durability), (RecordField)FloatLoadable.ANY.defaultField("accuracy", (Object)Float.valueOf(0.0f), true, GripMaterialStats::accuracy), (RecordField)FloatLoadable.FROM_ZERO.defaultField("melee_damage", (Object)Float.valueOf(0.0f), true, GripMaterialStats::meleeDamage), GripMaterialStats::new));
    private static final String DURABILITY_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("durability"));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)IMaterialStats.makeTooltip(TConstruct.getResource("handle.durability.description")), (Object)ToolStats.ACCURACY.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());

    @Override
    public MaterialStatType<?> getType() {
        return TYPE;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatColoredPercentBoost(DURABILITY_PREFIX, this.durability));
        info.add(IToolStat.formatColoredBonus(LimbMaterialStats.ACCURACY_PREFIX, this.accuracy));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.meleeDamage));
        return info;
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.percent(builder, this.durability * scale);
        ToolStats.ACCURACY.add(builder, this.accuracy * scale);
        ToolStats.ATTACK_DAMAGE.update(builder, Float.valueOf(this.meleeDamage * scale));
    }
}

