/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppingItem;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.config.ListType;
import ht.treechop.common.config.Rounder;
import ht.treechop.common.config.Signal;
import ht.treechop.common.config.TreeLeavesBehavior;
import ht.treechop.common.config.resource.ResourceIdentifier;
import ht.treechop.common.platform.ModLoader;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.compat.HugeFungusHandler;
import ht.treechop.compat.HugeMushroomHandler;
import ht.treechop.compat.ProblematicLeavesTreeHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Signal<Lazy<?>> RELOAD;
    public static final Lazy<ChopSettings> defaultChopSettings;
    public static final Lazy<ChopSettings> fakePlayerChopSettings;
    private static final Signal<Lazy<?>> UPDATE_TAGS;
    public static Lazy<Boolean> removeBarkOnInteriorLogs;
    public static Lazy<Map<Block, BlockState>> inferredStrippedStates;
    private static org.apache.logging.log4j.Level logLevel;

    public static void onReload() {
        ConfigHandler.updateLogLevel();
        RELOAD.run();
        ConfigHandler.updateTags();
    }

    public static void updateTags() {
        UPDATE_TAGS.run();
    }

    private static void updateLogLevel() {
        org.apache.logging.log4j.Level newLevel;
        org.apache.logging.log4j.Level level = newLevel = (Boolean)ConfigHandler.COMMON.enableLogging.get() != false ? org.apache.logging.log4j.Level.ALL : org.apache.logging.log4j.Level.OFF;
        if (newLevel != logLevel) {
            Configurator.setLevel((String)"treechop", (org.apache.logging.log4j.Level)org.apache.logging.log4j.Level.ALL);
            TreeChop.LOGGER.info("Changing log level to {}", (Object)newLevel.name());
            Configurator.setLevel((String)"treechop", (org.apache.logging.log4j.Level)newLevel);
            logLevel = newLevel;
        }
    }

    @NotNull
    private static Map<Block, BlockState> inferStrippedStates() {
        Set<Block> choppableBlocks = ConfigHandler.COMMON.choppableBlocks.get();
        HashMap<Block, BlockState> map = new HashMap<Block, BlockState>();
        choppableBlocks.forEach(block -> {
            Block unstripped = ConfigHandler.inferUnstripped(block);
            if (unstripped != Blocks.f_50016_ && !AxeAccessor.isStrippable(unstripped)) {
                map.put(unstripped, block.m_49966_());
            }
        });
        return map;
    }

    private static Block inferUnstripped(Block block) {
        ResourceLocation resource = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return ConfigHandler.inferUnstripped(resource);
    }

    private static Block inferUnstripped(ResourceLocation resource) {
        ResourceLocation unstripped;
        if (resource != null && (unstripped = ConfigHandler.getFilteredResourceLocation(resource, "stripped")) != null) {
            return (Block)BuiltInRegistries.f_256975_.m_7745_(unstripped);
        }
        return Blocks.f_50016_;
    }

    private static ResourceLocation getFilteredResourceLocation(ResourceLocation resource, String filterTerm) {
        String unstrippedPath;
        String strippedPath;
        if (resource != null && !(strippedPath = resource.m_135815_()).equals(unstrippedPath = Arrays.stream(strippedPath.split("_")).filter(token -> !token.equals(filterTerm)).collect(Collectors.joining("_")))) {
            return new ResourceLocation(resource.m_135827_(), unstrippedPath);
        }
        return null;
    }

    public static Stream<Item> getIdentifiedItems(String stringId) {
        ResourceIdentifier id = ResourceIdentifier.from(stringId);
        return id.resolve(BuiltInRegistries.f_257033_);
    }

    public static Stream<Block> getIdentifiedBlocks(String stringId) {
        ResourceIdentifier id = ResourceIdentifier.from(stringId);
        return id.resolve(BuiltInRegistries.f_256975_);
    }

    public static Stream<Block> getIdentifiedBlocks(List<? extends String> strings) {
        return strings.stream().flatMap(ConfigHandler::getIdentifiedBlocks);
    }

    public static boolean canChopWithTool(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState) {
        IChoppingItem choppingItem = TreeChop.api.getRegisteredChoppingItemBehavior(tool.m_41720_());
        return choppingItem != null ? choppingItem.canChop(player, tool, level, pos, blockState) : ConfigHandler.choppingItemIsBlacklisted(tool.m_41720_());
    }

    private static boolean choppingItemIsBlacklisted(Item item) {
        return ((ListType)((Object)ConfigHandler.COMMON.itemsBlacklistOrWhitelist.get())).accepts(ConfigHandler.COMMON.choppingItemsList.get().contains(item));
    }

    public static Permissions getServerPermissions() {
        return new Permissions(ConfigHandler.COMMON.rawPermissions.stream().filter(settingAndConfig -> (Boolean)((ForgeConfigSpec.BooleanValue)settingAndConfig.getValue()).get()).map(Pair::getKey).collect(Collectors.toSet()));
    }

    private static <T> InitializedSupplier<T> defaultValue(T defaultValue) {
        return new InitializedSupplier<Object>(() -> defaultValue);
    }

    public static String getCommonTagId(String path) {
        return String.format("#%s:%s", TreeChop.platform.uses(ModLoader.FORGE) ? "forge" : "c", path);
    }

    static {
        RELOAD = new Signal<Lazy>(Lazy::reset);
        defaultChopSettings = new Lazy<ChopSettings>(RELOAD, () -> {
            ChopSettings chopSettings = new ChopSettings();
            Permissions permissions = ConfigHandler.getServerPermissions();
            chopSettings.forEach((field, value) -> {
                if (!permissions.isPermitted((SettingsField)((Object)((Object)field)), value)) {
                    chopSettings.set((SettingsField)((Object)((Object)field)), field.getValues().stream().filter(candidate -> permissions.isPermitted(new Setting((SettingsField)((Object)((Object)field)), candidate))).findFirst().orElse(value));
                }
            });
            return chopSettings;
        });
        fakePlayerChopSettings = new Lazy<ChopSettings>(RELOAD, () -> new ChopSettings().setChoppingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerChoppingEnabled.get()).setFellingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerFellingEnabled.get()).setTreesMustHaveLeaves((Boolean)ConfigHandler.COMMON.fakePlayerTreesMustHaveLeaves.get()));
        UPDATE_TAGS = new Signal<Lazy>(Lazy::reset);
        removeBarkOnInteriorLogs = new Lazy<Boolean>(RELOAD, () -> {
            try {
                return (Boolean)ConfigHandler.CLIENT.removeBarkOnInteriorLogs.get();
            }
            catch (IllegalStateException e) {
                return false;
            }
        });
        inferredStrippedStates = new Lazy<Map>(UPDATE_TAGS, ConfigHandler::inferStrippedStates);
        logLevel = org.apache.logging.log4j.Level.ALL;
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.BooleanValue enableLogging;
        public final ForgeConfigSpec.BooleanValue dropLootForChoppedBlocks;
        public final ForgeConfigSpec.BooleanValue dropLootOnFirstChop;
        public final ForgeConfigSpec.IntValue maxNumTreeBlocks;
        public final ForgeConfigSpec.IntValue maxNumLeavesBlocks;
        public final ForgeConfigSpec.BooleanValue breakLeaves;
        public final ForgeConfigSpec.BooleanValue ignorePersistentLeaves;
        public final ForgeConfigSpec.IntValue maxBreakLeavesDistance;
        public final ForgeConfigSpec.EnumValue<ChopCountingAlgorithm> chopCountingAlgorithm;
        public final ForgeConfigSpec.EnumValue<Rounder> chopCountRounding;
        public final ForgeConfigSpec.BooleanValue canRequireMoreChopsThanBlocks;
        public final ForgeConfigSpec.DoubleValue logarithmicA;
        public final ForgeConfigSpec.DoubleValue linearM;
        public final ForgeConfigSpec.DoubleValue linearB;
        public final ForgeConfigSpec.EnumValue<ListType> itemsBlacklistOrWhitelist;
        public final ForgeConfigSpec.BooleanValue mustUseCorrectToolForDrops;
        public final ForgeConfigSpec.BooleanValue mustUseFastBreakingTool;
        public final ForgeConfigSpec.BooleanValue preventChoppingOnRightClick;
        public final ForgeConfigSpec.BooleanValue preventChopRecursion;
        public final ForgeConfigSpec.BooleanValue fakePlayerChoppingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerFellingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerTreesMustHaveLeaves;
        public final InitializedSupplier<Boolean> compatForCarryOn = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForProjectMMO = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForTheOneProbe = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForSilentGear = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Integer> silentGearSawChops = ConfigHandler.defaultValue(5);
        public final InitializedSupplier<Boolean> compatForTerraformers = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForTinkersConstruct = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForMultiMine = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Boolean> compatForApotheosis = ConfigHandler.defaultValue(true);
        public final InitializedSupplier<Integer> tinkersConstructTreeAOEChops = ConfigHandler.defaultValue(5);
        public final InitializedSupplier<Integer> tinkersConstructWoodAOEChops = ConfigHandler.defaultValue(5);
        public final InitializedSupplier<Double> tinkersConstructExpandedMultiplier = ConfigHandler.defaultValue(2.0);
        public final ForgeConfigSpec.BooleanValue verboseAPI;
        protected final List<Pair<Setting, ForgeConfigSpec.BooleanValue>> rawPermissions = new LinkedList<Pair<Setting, ForgeConfigSpec.BooleanValue>>();
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppableBlocksList;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppableBlocksExceptionsList;
        public final Lazy<Set<Block>> choppableBlocks = new Lazy<Set>(UPDATE_TAGS, () -> {
            Set exceptions = ConfigHandler.getIdentifiedBlocks((List)ConfigHandler.COMMON.choppableBlocksExceptionsList.get()).collect(Collectors.toSet());
            Set blocks = ConfigHandler.getIdentifiedBlocks((List)ConfigHandler.COMMON.choppableBlocksList.get()).filter(block -> !exceptions.contains(block)).collect(Collectors.toSet());
            TreeChop.api.getChoppableBlockOverrides().forEach(blockIsChoppable -> {
                if (((Boolean)blockIsChoppable.getValue()).booleanValue()) {
                    blocks.add((Block)blockIsChoppable.getKey());
                } else {
                    blocks.remove(blockIsChoppable.getKey());
                }
            });
            return blocks;
        });
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> leavesBlocksList;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> leavesBlocksExceptionsList;
        public final Lazy<Map<Block, TreeLeavesBehavior>> leavesBlocks = new Lazy<Map>(UPDATE_TAGS, () -> {
            Set exceptions = ConfigHandler.getIdentifiedBlocks((List)ConfigHandler.COMMON.leavesBlocksExceptionsList.get()).collect(Collectors.toSet());
            Map blocks = ConfigHandler.getIdentifiedBlocks((List)ConfigHandler.COMMON.leavesBlocksList.get()).filter(block -> !exceptions.contains(block)).collect(Collectors.toConcurrentMap(k -> k, v -> TreeLeavesBehavior.DEFAULT, (a, b) -> b));
            TreeChop.api.getLeavesBlockOverrides().forEach(blockIsLeaves -> {
                if (((Boolean)blockIsLeaves.getValue()).booleanValue()) {
                    blocks.put((Block)blockIsLeaves.getKey(), TreeLeavesBehavior.PROBLEMATIC);
                } else {
                    blocks.remove(blockIsLeaves.getKey());
                }
            });
            return blocks;
        });
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> choppingItemsToBlacklistOrWhitelist;
        public final Lazy<Set<Item>> choppingItemsList = new Lazy<Set>(UPDATE_TAGS, () -> {
            Set items = ((List)ConfigHandler.COMMON.choppingItemsToBlacklistOrWhitelist.get()).stream().flatMap(ConfigHandler::getIdentifiedItems).collect(Collectors.toSet());
            ListType blackListOrWhiteList = (ListType)((Object)((Object)ConfigHandler.COMMON.itemsBlacklistOrWhitelist.get()));
            TreeChop.api.getChoppingItemOverrides().forEach(itemCanChop -> {
                if (blackListOrWhiteList.accepts((Boolean)itemCanChop.getValue())) {
                    items.add((Item)itemCanChop.getKey());
                } else {
                    items.remove(itemCanChop.getKey());
                }
            });
            return items;
        });

        public Common(ForgeConfigSpec.Builder builder) {
            String blockIdsHelp = String.join((CharSequence)"\n", "For block lists, specify using registry names (mod:block), tags (#mod:tag), namespaces (@mod), and Java-style regular expressions", "Regular expressions must match the whole resource name, including the colon. Some simple examples are:", " - To match any block ending in _log: \".*_log\", where .* is a wildcard", " - You can also specify a mod: \"treemod:.*_log\"", " - To also match stripped versions: \".*_log(_stripped)?\", where ? means that the text in the parenthesis is optional", "For more help, see https://github.com/hammertater/treechop/wiki/Configuration");
            builder.push("mod");
            this.enabled = builder.comment("Set to false to disable TreeChop without having to uninstall the mod").define("enabled", true);
            this.enableLogging = builder.comment("Let TreeChop print to the log").define("printDebugInfo", true);
            builder.pop();
            builder.push("permissions");
            for (SettingsField field : SettingsField.values()) {
                String fieldName = field.getConfigKey();
                for (Object value : field.getValues()) {
                    String valueName = this.getPrettyValueName(value);
                    ForgeConfigSpec.BooleanValue configHandle = builder.define(fieldName + ".canBe" + valueName, true);
                    this.rawPermissions.add((Pair<Setting, ForgeConfigSpec.BooleanValue>)Pair.of((Object)new Setting(field, value), (Object)configHandle));
                }
            }
            builder.pop();
            builder.push("general");
            this.dropLootForChoppedBlocks = builder.comment("If false, log items will be destroyed when chopping").define("dropLootForChoppedBlocks", true);
            this.dropLootOnFirstChop = builder.comment("If true, chopped logs will drop a log item immediately instead of waiting for the tree to be felled, restoring legacy behavior. Does nothing if dropLootForChoppedBlocks is false").define("dropLootOnFirstChop", false);
            builder.pop();
            builder.push("treeDetection");
            this.maxNumTreeBlocks = builder.comment("Maximum number of log blocks that can be detected to belong to one tree").defineInRange("maxTreeBlocks", 1024, 1, 8096);
            this.maxNumLeavesBlocks = builder.comment("Maximum number of leaves blocks that can destroyed when a tree is felled").defineInRange("maxLeavesBlocks", 1024, 1, 8096);
            this.breakLeaves = builder.comment("Destroy leaves when a tree is felled").define("breakLeaves", true);
            this.ignorePersistentLeaves = builder.comment("Non-decayable leaves are ignored when detecting leaves").define("ignorePersistentLeaves", true);
            this.maxBreakLeavesDistance = builder.comment("Maximum distance from log blocks to destroy leaves blocks when felling").defineInRange("maxBreakLeavesDistance", 7, 0, 16);
            builder.push("logs");
            this.choppableBlocksList = builder.comment(String.join((CharSequence)"\n", "Blocks that should be considered choppable", blockIdsHelp)).defineList("blocks", List.of("#treechop:choppables", "#minecraft:logs"), always -> true);
            this.choppableBlocksExceptionsList = builder.comment(String.join((CharSequence)"\n", "Blocks that should never be chopped, even if included in the list above", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("exceptions", List.of("minecraft:bamboo", "#dynamictrees:branches", "dynamictrees:trunk_shell"), always -> true);
            builder.pop();
            builder.push("leaves");
            this.leavesBlocksList = builder.comment(String.join((CharSequence)"\n", "Blocks that should be considered leaves", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("blocks", List.of("#treechop:leaves_like", "#minecraft:leaves", "pamhc2trees:pam[a-z]+"), always -> true);
            this.leavesBlocksExceptionsList = builder.comment(String.join((CharSequence)"\n", "Blocks that should never be considered leaves, even if included in the list above", "Specify using registry names (mod:block), tags (#mod:tag), and namespaces (@mod)")).defineList("exceptions", List.of(), always -> true);
            builder.pop();
            builder.pop();
            builder.push("chopCounting");
            this.chopCountingAlgorithm = builder.comment("Method to use for computing the number of chops needed to fell a tree").defineEnum("algorithm", (Enum)ChopCountingAlgorithm.LOGARITHMIC);
            this.chopCountRounding = builder.comment("How to round the number of chops needed to fell a tree; this is more meaningful for smaller trees").defineEnum("rounding", (Enum)Rounder.NEAREST);
            this.canRequireMoreChopsThanBlocks = builder.comment("Felling a tree can require more chops than the number of blocks in the tree").define("canRequireMoreChopsThanBlocks", false);
            builder.comment("See https://github.com/hammertater/treechop/#logarithmic").push("logarithmic");
            this.logarithmicA = builder.comment("Determines the number of chops required to fell a tree; higher values require more chops for bigger trees").defineInRange("a", 10.0, 0.0, 10000.0);
            builder.pop();
            builder.comment("See https://github.com/hammertater/treechop/#linear").push("linear");
            this.linearM = builder.comment("The number of chops per block required to fell a tree; if chopsPerBlock = 0.5, it will take 50 chops to fell a 100 block tree").defineInRange("chopsPerBlock", 1.0, 0.0, 7.0);
            this.linearB = builder.comment("The base number of chops required to fell a tree regardless of its size").defineInRange("baseNumChops", 0.0, -10000.0, 10000.0);
            builder.pop();
            builder.pop();
            builder.push("compatibility");
            builder.push("general");
            this.mustUseCorrectToolForDrops = builder.comment("Only chop when using the correct tool for drops, if any (does nothing in vanilla, but some mods add tool requirements to logs").define("choppingRequiresCorrectToolForDrops", true);
            this.mustUseFastBreakingTool = builder.comment("Only chop when using a tool that increases block breaking speed (such as axes for logs)").define("choppingRequiresFastBreakingTool", false);
            this.preventChoppingOnRightClick = builder.comment("Prevent chopping when right-clicking blocks").define("preventChoppingOnRightClick", false);
            this.preventChopRecursion = builder.comment("Prevent infinite loops when chopping; fixes crashes when using modded items that break multiple blocks").define("preventChopRecursion", true);
            builder.push("blacklist");
            this.itemsBlacklistOrWhitelist = builder.comment("Whether the listed items should be blacklisted or whitelisted").defineEnum("blacklistOrWhitelist", (Enum)ListType.BLACKLIST);
            this.choppingItemsToBlacklistOrWhitelist = builder.comment(String.join((CharSequence)"\n", "List of item registry names (mod:item), tags (#mod:tag), and namespaces (@mod) for items that should not chop when used to break a log", "- Items in this list that have special support for TreeChop will not be blacklisted; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#blacklist")).defineList("items", Arrays.asList("botania:terra_axe", "@lumberjack", "mekanism:atomic_disassembler", "practicaltools:diamond_greataxe", "practicaltools:golden_greataxe", "practicaltools:iron_greataxe", "practicaltools:netherite_greataxe", "twilightforest:giant_pickaxe"), always -> true);
            builder.pop();
            builder.comment("The chop settings used by non-player entities, such as robots and machine blocks");
            builder.push("fakePlayerChopSettings");
            this.fakePlayerChoppingEnabled = builder.comment("Use with caution! May cause conflicts with some mods, e.g. https://github.com/hammertater/treechop/issues/71").define("choppingEnabled", false);
            this.fakePlayerFellingEnabled = builder.comment("Felling only matters if chopping is enabled; probably best to leave this on").define("fellingEnabled", true);
            this.fakePlayerTreesMustHaveLeaves = builder.define("treesMustHaveLeaves", true);
            builder.pop();
            builder.pop();
            builder.comment(String.join((CharSequence)"\n", "A set of alternate tree detection strategies for oddly shaped trees", blockIdsHelp));
            builder.push("trees");
            HugeMushroomHandler.MyConfigHandler.init(builder);
            HugeFungusHandler.MyConfigHandler.init(builder);
            ProblematicLeavesTreeHandler.MyConfigHandler.init(builder);
            builder.pop();
            if (TreeChop.platform.uses(ModLoader.FORGE)) {
                this.compatForCarryOn.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://www.curseforge.com/minecraft/mc-mods/carry-on", "https://modrinth.com/mod/carry-on", "Small fixes."}).define("carryOn", true)).get());
                this.compatForProjectMMO.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://www.curseforge.com/minecraft/mc-mods/project-mmo", "https://modrinth.com/mod/project-mmo", "Award woodcutting XP for chopping."}).define("projectMMO", true)).get());
                this.compatForTheOneProbe.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://www.curseforge.com/minecraft/mc-mods/the-one-probe", "https://modrinth.com/mod/the-one-probe", "Shows the number of chops required to fell a tree and what loot will drop."}).define("theOneProbe", true)).get());
                this.compatForTerraformers.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://github.com/TerraformersMC", "Fixes starting chop radius for small logs from Terraformers mods (Terrestria, etc.)"}).define("terraformers", true)).get());
                this.compatForMultiMine.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://github.com/AtomicStryker/atomicstrykers-minecraft-mods", "Fixes bad behavior"}).define("multiMine", true)).get());
                this.compatForApotheosis.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://www.curseforge.com/minecraft/mc-mods/apotheosis", "Adds compatibility with the \"chainsaw\" enchantment."}).define("apotheosis", true)).get());
                builder.push("silentgear");
                this.compatForSilentGear.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://www.curseforge.com/minecraft/mc-mods/tinkers-construct", "https://modrinth.com/mod/tinkers-construct", "Makes saws do more chops."}).define("enabled", true)).get());
                this.silentGearSawChops.set(() -> ((ForgeConfigSpec.IntValue)builder.comment("Number of chops a saw should perform on a single block break").defineInRange("sawChops", 5, 1, 10000)).get());
                builder.pop();
                builder.push("tinkersConstruct");
                this.compatForTinkersConstruct.set(() -> ((ForgeConfigSpec.BooleanValue)builder.comment(new String[]{"https://www.curseforge.com/minecraft/mc-mods/tinkers-construct", "https://modrinth.com/mod/tinkers-construct", "Makes AOE tools do more chops."}).define("enabled", true)).get());
                this.tinkersConstructTreeAOEChops.set(() -> ((ForgeConfigSpec.IntValue)builder.comment("Number of chops that tree breaking tools (like broad axes) should perform on a single block break").defineInRange("treeBreakingTools", 5, 1, 10000)).get());
                this.tinkersConstructWoodAOEChops.set(() -> ((ForgeConfigSpec.IntValue)builder.comment("Number of chops that wood breaking tools (like hand axes) should perform on a single block break").defineInRange("woodBreakingTools", 1, 1, 10000)).get());
                this.tinkersConstructExpandedMultiplier.set(() -> ((ForgeConfigSpec.DoubleValue)builder.comment("The chop count multiplier for each level of the expanded upgrade").defineInRange("expandedMultiplier", 2.0, 1.0, 10000.0)).get());
                builder.pop();
            }
            builder.push("API");
            this.verboseAPI = builder.comment("Log information about TreeChop API usage. May be useful for debugging mod compatibility issues.").define("verbose", false);
            builder.pop();
            builder.pop();
        }

        private String getPrettyValueName(Object value) {
            return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
        }
    }

    public static class InitializedSupplier<T>
    implements Supplier<T> {
        private Supplier<T> supplier;

        public InitializedSupplier(Supplier<T> defaultSupplier) {
            this.supplier = defaultSupplier;
        }

        @Override
        public T get() {
            return this.supplier.get();
        }

        private void set(Supplier<T> newSupplier) {
            this.supplier = newSupplier;
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue choppingEnabled;
        public final ForgeConfigSpec.BooleanValue fellingEnabled;
        public final ForgeConfigSpec.EnumValue<SneakBehavior> sneakBehavior;
        public final ForgeConfigSpec.BooleanValue treesMustHaveLeaves;
        public final ForgeConfigSpec.BooleanValue chopInCreativeMode;
        public final ForgeConfigSpec.BooleanValue showChoppingIndicators;
        private final ForgeConfigSpec.BooleanValue removeBarkOnInteriorLogs;
        public final ForgeConfigSpec.IntValue indicatorXOffset;
        public final ForgeConfigSpec.IntValue indicatorYOffset;
        public final ForgeConfigSpec.BooleanValue showFellingOptions;
        public final ForgeConfigSpec.BooleanValue showFeedbackMessages;
        public final ForgeConfigSpec.BooleanValue showTooltips;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("chopping");
            this.choppingEnabled = builder.comment("Default setting for whether or not the user wishes to chop (can be toggled in-game)").define("choppingEnabled", true);
            this.fellingEnabled = builder.comment("Default setting for whether or not the user wishes to fell tree when chopping (can be toggled in-game)").define("fellingEnabled", true);
            this.sneakBehavior = builder.comment("Default setting for the effect that sneaking has on chopping (can be cycled in-game)").defineEnum("sneakBehavior", (Enum)SneakBehavior.INVERT_CHOPPING);
            this.treesMustHaveLeaves = builder.comment("Ignore trees without connected leaves (can be toggled in-game)").define("treesMustHaveLeaves", true);
            this.chopInCreativeMode = builder.comment("Enable chopping in creative mode (even when false, sneaking can still enable chopping) (can be toggled in-game)").define("chopInCreativeMode", false);
            builder.pop();
            builder.push("visuals");
            this.removeBarkOnInteriorLogs = builder.comment("Visually replace the interior sides of logs with a chopped texture instead of bark").define("removeBarkOnInteriorLogs", true);
            builder.push("choppingIndicator");
            this.showChoppingIndicators = builder.comment("Show an on-screen indicator when a block will be chopped instead of broken (can be toggled in-game)").define("enabled", true);
            this.indicatorXOffset = builder.comment("Horizontal location of the indicator relative to the player's crosshairs; positive values move the indicator to the right").defineInRange("xOffset", 16, -256, 256);
            this.indicatorYOffset = builder.comment("Vertical location of the indicator relative to the player's crosshairs; positive values move the indicator down").defineInRange("yOffset", 0, -256, 256);
            builder.pop();
            builder.pop();
            builder.push("settingsScreen");
            this.showFellingOptions = builder.comment("Show in-game options for enabling and disable felling (can be toggled in-game)").define("showFellingOptions", false);
            this.showFeedbackMessages = builder.comment("Show chat confirmations when using hotkeys to change chop settings (can be toggled in-game)").define("showFeedbackMessages", true);
            this.showTooltips = builder.comment("Show tooltips in the settings screen (can be toggled in-game)").define("showTooltips", true);
            builder.pop();
        }

        public ChopSettings getChopSettings() {
            ChopSettings chopSettings = new ChopSettings();
            chopSettings.setChoppingEnabled((Boolean)ConfigHandler.CLIENT.choppingEnabled.get());
            chopSettings.setFellingEnabled((Boolean)ConfigHandler.CLIENT.fellingEnabled.get());
            chopSettings.setSneakBehavior((SneakBehavior)((Object)ConfigHandler.CLIENT.sneakBehavior.get()));
            chopSettings.setTreesMustHaveLeaves((Boolean)ConfigHandler.CLIENT.treesMustHaveLeaves.get());
            chopSettings.setChopInCreativeMode((Boolean)ConfigHandler.CLIENT.chopInCreativeMode.get());
            return chopSettings;
        }
    }
}

