/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import ht.treechop.TreeChop;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class SyncedChopData {
    protected static final String FELLING_ENABLED_KEY = "fellingEnabled";
    protected static final String CHOPPING_ENABLED_KEY = "choppingEnabled";
    protected static final String SNEAK_BEHAVIOR_KEY = "sneakBehavior";
    protected static final String TREES_MUST_HAVE_LEAVES_KEY = "treesMustHaveLeaves";
    protected static final String CHOP_IN_CREATIVE_MODE_KEY = "chopInCreativeMode";
    protected static final String IS_SYNCED_KEY = "isSynced";
    private final ChopSettings settings;
    private boolean isSynced = false;

    public SyncedChopData(ChopSettings settings) {
        this.settings = settings;
    }

    public ChopSettings getSettings() {
        return this.settings;
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public CompoundTag makeSaveData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(CHOPPING_ENABLED_KEY, this.settings.getChoppingEnabled());
        nbt.m_128379_(FELLING_ENABLED_KEY, this.settings.getFellingEnabled());
        nbt.m_128359_(SNEAK_BEHAVIOR_KEY, this.settings.getSneakBehavior().name());
        nbt.m_128379_(TREES_MUST_HAVE_LEAVES_KEY, this.settings.getTreesMustHaveLeaves());
        nbt.m_128379_(CHOP_IN_CREATIVE_MODE_KEY, this.settings.getChopInCreativeMode());
        nbt.m_128379_(IS_SYNCED_KEY, this.isSynced());
        return nbt;
    }

    public SyncedChopData readSaveData(CompoundTag tag) {
        if (tag.m_128441_(IS_SYNCED_KEY)) {
            String sneakBehaviorId;
            Optional<Boolean> choppingEnabled = this.getBoolean(tag, CHOPPING_ENABLED_KEY);
            Optional<Boolean> fellingEnabled = this.getBoolean(tag, FELLING_ENABLED_KEY);
            Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(tag, TREES_MUST_HAVE_LEAVES_KEY);
            Optional<Boolean> chopInCreativeMode = this.getBoolean(tag, CHOP_IN_CREATIVE_MODE_KEY);
            Optional<Boolean> isSynced = this.getBoolean(tag, IS_SYNCED_KEY);
            SneakBehavior defaultSneakBehavior = ConfigHandler.defaultChopSettings.get().getSneakBehavior();
            String string = sneakBehaviorId = tag.m_128441_(SNEAK_BEHAVIOR_KEY) ? tag.m_128461_(SNEAK_BEHAVIOR_KEY) : "";
            if (sneakBehaviorId.isEmpty()) {
                this.settings.setSneakBehavior(defaultSneakBehavior);
            } else {
                SneakBehavior sneakBehavior;
                try {
                    sneakBehavior = SneakBehavior.valueOf(sneakBehaviorId);
                }
                catch (IllegalArgumentException e) {
                    TreeChop.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value \"%s\"", tag.m_128461_(SNEAK_BEHAVIOR_KEY), defaultSneakBehavior.name()));
                    sneakBehavior = defaultSneakBehavior;
                }
                this.settings.setSneakBehavior(sneakBehavior);
            }
            this.settings.setChoppingEnabled(choppingEnabled.orElse(this.settings.getChoppingEnabled()));
            this.settings.setFellingEnabled(fellingEnabled.orElse(this.settings.getFellingEnabled()));
            this.settings.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(this.settings.getTreesMustHaveLeaves()));
            this.settings.setChopInCreativeMode(chopInCreativeMode.orElse(this.settings.getChopInCreativeMode()));
            if (isSynced.orElse(false).booleanValue()) {
                this.setSynced();
            }
        }
        return this;
    }

    protected Optional<Boolean> getBoolean(CompoundTag CompoundTag2, String key) {
        return CompoundTag2.m_128441_(key) ? Optional.of(CompoundTag2.m_128471_(key)) : Optional.empty();
    }
}

