/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.electricity.formatting;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.electricity.formatting.MeasurementUnits;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ChatFormatter {
    public static MutableComponent getChatDisplay(double value, IDisplayUnit unit, int decimalPlaces, boolean isShort) {
        if (value < -9.223372036854766E18) {
            return Component.m_237113_((String)"-").m_7220_((Component)VoltaicTextUtils.gui("displayunit.infinity.name", new Object[0])).m_130946_(" ").m_7220_(isShort ? unit.getSymbol() : unit.getNamePlural());
        }
        if (value > 9.223372036854766E18) {
            return VoltaicTextUtils.gui("displayunit.infinity.name", new Object[0]).m_130946_(" ").m_7220_(isShort ? unit.getSymbol() : unit.getNamePlural());
        }
        Component unitName = isShort ? unit.getSymbol() : (value > 1.0 ? unit.getNamePlural() : unit.getName());
        if (value == 0.0) {
            return Component.m_237113_((String)("" + value)).m_7220_(unit.getDistanceFromValue()).m_7220_(unitName);
        }
        for (int i = 0; i < MeasurementUnits.values().length; ++i) {
            MeasurementUnits measurement = MeasurementUnits.values()[i];
            if (!(value < measurement.getValue())) continue;
            if (i == 0) {
                return ChatFormatter.formatDecimals(measurement.process(value), decimalPlaces).m_7220_(unit.getDistanceFromValue()).m_7220_(measurement.getName(isShort)).m_7220_(unitName);
            }
            measurement = MeasurementUnits.values()[i - 1];
            return ChatFormatter.formatDecimals(measurement.process(value), decimalPlaces).m_7220_(unit.getDistanceFromValue()).m_7220_(measurement.getName(isShort)).m_7220_(unitName);
        }
        MeasurementUnits measurement = MeasurementUnits.values()[MeasurementUnits.values().length - 1];
        return ChatFormatter.formatDecimals(measurement.process(value), decimalPlaces).m_7220_(unit.getDistanceFromValue()).m_7220_(measurement.getName(isShort)).m_7220_(unitName);
    }

    public static MutableComponent getChatDisplay(double value, IDisplayUnit unit) {
        return ChatFormatter.getChatDisplay(value, unit, 2, false);
    }

    public static MutableComponent getChatDisplayShort(double value, IDisplayUnit unit) {
        return ChatFormatter.getChatDisplay(value, unit, 2, true);
    }

    public static MutableComponent getDisplayShort(double value, IDisplayUnit unit, int decimalPlaces) {
        return ChatFormatter.getChatDisplay(value, unit, decimalPlaces, true);
    }

    public static MutableComponent getChatDisplaySimple(double value, IDisplayUnit unit, int decimalPlaces) {
        if (value > 1.0) {
            if (decimalPlaces < 1) {
                return Component.m_237113_((String)("" + (int)value)).m_7220_(unit.getDistanceFromValue()).m_7220_(unit.getNamePlural());
            }
            return ChatFormatter.formatDecimals(value, decimalPlaces).m_7220_(unit.getDistanceFromValue()).m_7220_(unit.getNamePlural());
        }
        if (decimalPlaces < 1) {
            return Component.m_237113_((String)("" + (int)value)).m_7220_(unit.getDistanceFromValue()).m_7220_(unit.getName());
        }
        return ChatFormatter.formatDecimals(value, decimalPlaces).m_7220_(unit.getDistanceFromValue()).m_7220_(unit.getName());
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static MutableComponent formatDecimals(double d, int decimalPlaces) {
        DecimalFormat format = new DecimalFormat("0" + ChatFormatter.getDecimals(decimalPlaces));
        format.setRoundingMode(RoundingMode.HALF_EVEN);
        return Component.m_237113_((String)format.format(ChatFormatter.roundDecimals(d, decimalPlaces)));
    }

    public static MutableComponent formatFluidMilibuckets(double amount) {
        return ChatFormatter.getChatDisplayShort(amount / 1000.0, DisplayUnits.BUCKETS);
    }

    private static String getDecimals(int num) {
        if (num <= 0) {
            return ".";
        }
        --num;
        Object key = ".0";
        for (int i = 0; i < num; ++i) {
            key = (String)key + "#";
        }
        return key;
    }
}

