/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.network.util;

import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.prefab.network.AbstractNetwork;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;

public class AbstractNetworkFinder<C extends GenericRefreshingConnectTile<T, C, ?>, T, P> {
    private final Level level;
    private final BlockPos start;
    private final AbstractNetwork<C, T, P, ?> net;
    private final HashSet<C> iteratedTiles = new HashSet();
    private final HashSet<BlockPos> toIgnore = new HashSet();

    public AbstractNetworkFinder(Level world, BlockPos start, AbstractNetwork<C, T, P, ?> net, BlockPos ... ignore) {
        this.level = world;
        this.start = start;
        this.net = net;
        if (ignore.length > 0) {
            this.toIgnore.addAll(List.of(ignore));
        }
    }

    private void loopAll(BlockPos location) {
        BlockEntity curr = this.level.m_7702_(location);
        if (this.net.isConductor(curr, (GenericRefreshingConnectTile)curr)) {
            this.iteratedTiles.add((GenericRefreshingConnectTile)curr);
        }
        for (Direction direction : Direction.values()) {
            BlockEntity tileEntity;
            BlockPos relative = new BlockPos((Vec3i)location).m_121945_(direction);
            if (this.toIgnore.contains(relative) || !this.level.m_46805_(relative) || this.iteratedTiles.contains(tileEntity = this.level.m_7702_(relative)) || !this.net.isConductor(tileEntity, (GenericRefreshingConnectTile)curr)) continue;
            this.loopAll((GenericRefreshingConnectTile)tileEntity);
        }
    }

    private void loopAll(C cable) {
        this.iteratedTiles.add(cable);
        for (BlockEntity connection : ((GenericRefreshingConnectTile)cable).getConnectedCables()) {
            if (connection == null) continue;
            BlockPos pos = connection.m_58899_();
            if (this.iteratedTiles.contains(connection) || this.toIgnore.contains(pos) || !this.net.isConductor(connection, cable)) continue;
            this.loopAll((GenericRefreshingConnectTile)connection);
        }
    }

    public HashSet<C> exploreNetwork() {
        this.loopAll(this.start);
        return this.iteratedTiles;
    }
}

