/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.radiation.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.prefab.utilities.BlockEntityUtils;

public interface IRadiationManager {
    public List<SimpleRadiationSource> getPermanentSources(Level var1);

    public List<TemporaryRadiationSource> getTemporarySources(Level var1);

    public List<FadingRadiationSource> getFadingSources(Level var1);

    public List<BlockPos> getPermanentLocations(Level var1);

    public List<BlockPos> getTemporaryLocations(Level var1);

    public List<BlockPos> getFadingLocations(Level var1);

    public void addRadiationSource(SimpleRadiationSource var1, Level var2);

    public int getReachOfSource(Level var1, BlockPos var2);

    public void setDisipation(double var1, Level var3);

    public void setLocalizedDisipation(double var1, AABB var3, Level var4);

    public void removeLocalizedDisipation(AABB var1, Level var2);

    public boolean removeRadiationSource(BlockPos var1, boolean var2, Level var3);

    public void wipeAllSources(Level var1);

    public void tick(Level var1);

    public static class TemporaryRadiationSource {
        public static final TemporaryRadiationSource NONE = new TemporaryRadiationSource(0, 0.0, 0.0, false, 0, BlockEntityUtils.OUT_OF_REACH);
        public static final Codec<TemporaryRadiationSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("ticks").forGetter(instance0 -> instance0.ticks), (App)Codec.DOUBLE.fieldOf("strength").forGetter(instance0 -> instance0.strength), (App)Codec.DOUBLE.fieldOf("amount").forGetter(instance0 -> instance0.radiation), (App)Codec.BOOL.fieldOf("leavefading").forGetter(instance0 -> instance0.leaveFading), (App)Codec.INT.fieldOf("distance").forGetter(instance0 -> instance0.distance), (App)BlockPos.f_121852_.optionalFieldOf("position", (Object)BlockEntityUtils.OUT_OF_REACH).forGetter(instance0 -> instance0.position)).apply((Applicative)instance, TemporaryRadiationSource::new));
        public int ticks;
        public final double strength;
        public final double radiation;
        public final boolean leaveFading;
        public final int distance;
        public final BlockPos position;
        public final AABB boundingBox;
        public final ChunkPos chunkPos;

        public TemporaryRadiationSource(int ticks, double strength, double radiation, boolean leaveFading, int distance, BlockPos position) {
            this.ticks = ticks;
            this.strength = strength;
            this.radiation = radiation;
            this.leaveFading = leaveFading;
            this.distance = distance;
            this.position = position;
            this.boundingBox = new AABB(this.position).m_82400_((double)distance);
            this.chunkPos = new ChunkPos(position);
        }
    }

    public static class FadingRadiationSource {
        public static final FadingRadiationSource NONE = new FadingRadiationSource(0, 0.0, 0.0, BlockEntityUtils.OUT_OF_REACH);
        public static final Codec<FadingRadiationSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("distance").forGetter(instance0 -> instance0.distance), (App)Codec.DOUBLE.fieldOf("strength").forGetter(instance0 -> instance0.strength), (App)Codec.DOUBLE.fieldOf("amount").forGetter(instance0 -> instance0.radiation), (App)BlockPos.f_121852_.optionalFieldOf("position", (Object)BlockEntityUtils.OUT_OF_REACH).forGetter(instance0 -> instance0.position)).apply((Applicative)instance, FadingRadiationSource::new));
        public final int distance;
        public final BlockPos position;
        public double strength;
        public double radiation;
        public final AABB boundingBox;
        public final ChunkPos chunkPos;

        public FadingRadiationSource(int distance, double strength, double radiation, BlockPos position) {
            this.distance = distance;
            this.strength = strength;
            this.radiation = radiation;
            this.position = position;
            this.boundingBox = new AABB(this.position).m_82400_((double)distance);
            this.chunkPos = new ChunkPos(position);
        }
    }
}

