/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.registries.RegistryObject;

public class BulkRegistryObject<A, SUBTYPE> {
    private final HashMap<SUBTYPE, RegistryObject<A>> subtypeMap = new HashMap();
    private final List<A> extractedValues = new ArrayList<A>();
    private A[] extractedValuesArray;

    public BulkRegistryObject(SUBTYPE[] values, Function<SUBTYPE, RegistryObject<A>> factory) {
        this.subtypeMap.clear();
        this.extractedValues.clear();
        for (SUBTYPE subtype : values) {
            this.subtypeMap.put(subtype, factory.apply(subtype));
        }
    }

    public A getValue(SUBTYPE key) {
        return (A)this.subtypeMap.get(key).get();
    }

    public RegistryObject<A> getHolder(SUBTYPE key) {
        return this.subtypeMap.get(key);
    }

    public List<A> getAllValues() {
        if (this.extractedValues.isEmpty()) {
            this.subtypeMap.values().forEach(register -> this.extractedValues.add(register.get()));
        }
        return this.extractedValues;
    }

    public A[] getAllValuesArray(A[] newArray) {
        if (this.extractedValuesArray == null) {
            this.extractedValuesArray = this.getAllValues().toArray(newArray);
        }
        return this.extractedValuesArray;
    }

    public A[] getSpecificValuesArray(A[] newArray, SUBTYPE ... subtypes) {
        List<A> values = this.getSpecificValues(subtypes);
        return values.toArray(newArray);
    }

    public List<A> getSpecificValues(SUBTYPE ... subtypes) {
        ArrayList<A> values = new ArrayList<A>();
        for (SUBTYPE subtype : subtypes) {
            values.add(this.getValue(subtype));
        }
        return values;
    }

    public List<RegistryObject<A>> getAllHolders() {
        return this.subtypeMap.values().stream().toList();
    }

    public boolean containsValue(SUBTYPE key) {
        return this.subtypeMap.containsValue(key);
    }
}

