/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.guidebook.utils.pagedata.graphics;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import voltaic.client.guidebook.utils.components.Page;
import voltaic.client.guidebook.utils.pagedata.AbstractWrapperObject;
import voltaic.client.guidebook.utils.pagedata.OnClick;
import voltaic.client.guidebook.utils.pagedata.OnKeyPress;
import voltaic.client.guidebook.utils.pagedata.OnTooltip;

public abstract class AbstractGraphicWrapper<T extends AbstractGraphicWrapper<?>>
extends AbstractWrapperObject<T> {
    public final int width;
    public final int height;
    public final int trueHeight;
    public final int xOffset;
    public final int yOffset;
    public final int lookupXOffset;
    public final int lookupYOffset;
    public final int descriptorTopOffset;
    public final int descriptorBottomOffset;
    public boolean allowNextToOthers = false;
    public final GraphicTextDescriptor[] descriptors;

    public AbstractGraphicWrapper(int xOffset, int yOffset, int lookupXOffset, int lookupYOffset, int width, int height, int trueHeight, GraphicTextDescriptor ... descriptors) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.lookupXOffset = lookupXOffset;
        this.lookupYOffset = lookupYOffset;
        this.width = width;
        this.height = height;
        this.trueHeight = trueHeight;
        if (descriptors != null && descriptors.length > 0) {
            this.descriptors = descriptors;
            int highestDescriptor = 0;
            int lowestDescriptor = height + yOffset;
            for (GraphicTextDescriptor descriptor : descriptors) {
                if (descriptor.yOffsetFromImage < highestDescriptor) {
                    highestDescriptor = descriptor.yOffsetFromImage;
                    continue;
                }
                if (descriptor.yOffsetFromImage + 10 <= lowestDescriptor) continue;
                lowestDescriptor = descriptor.yOffsetFromImage + 10;
            }
            this.descriptorTopOffset = highestDescriptor;
            this.descriptorBottomOffset = lowestDescriptor - height - yOffset;
        } else {
            this.descriptors = new GraphicTextDescriptor[0];
            this.descriptorTopOffset = 0;
            this.descriptorBottomOffset = 0;
        }
    }

    @Override
    public T setNewPage() {
        this.newPage = true;
        return (T)this;
    }

    public T setHorizontalPlacement() {
        this.allowNextToOthers = true;
        return (T)this;
    }

    public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, Page var7);

    public static class GraphicTextDescriptor {
        public int xOffsetFromImage;
        public int yOffsetFromImage;
        public Component text;
        public int color;
        @Nullable
        public OnTooltip onTooltip = null;
        @Nullable
        public OnClick onClick = null;
        @Nullable
        public OnKeyPress onKeyPress = null;

        public GraphicTextDescriptor(int xOffsetFromImage, int yOffsetFromImage, Component text) {
            this(xOffsetFromImage, yOffsetFromImage, 0x404040, text);
        }

        public GraphicTextDescriptor(int xOffsetFromImage, int yOffsetFromImage, int color, Component text) {
            this.xOffsetFromImage = xOffsetFromImage;
            this.yOffsetFromImage = yOffsetFromImage;
            this.text = text;
            this.color = color;
        }

        public GraphicTextDescriptor onTooltip(OnTooltip onTooltip) {
            this.onTooltip = onTooltip;
            return this;
        }

        public GraphicTextDescriptor onClick(OnClick onClick) {
            this.onClick = onClick;
            return this;
        }

        public GraphicTextDescriptor onKeyPress(OnKeyPress onKeyPress) {
            this.onKeyPress = onKeyPress;
            return this;
        }
    }
}

