/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.guidebook.utils.pagedata.graphics;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import voltaic.client.guidebook.utils.components.Page;
import voltaic.client.guidebook.utils.pagedata.graphics.AbstractGraphicWrapper;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class FluidWrapperObject
extends AbstractGraphicWrapper<FluidWrapperObject> {
    public final Fluid fluid;

    public FluidWrapperObject(int xOffset, int yOffset, int width, int height, int trueHeight, Fluid fluid, AbstractGraphicWrapper.GraphicTextDescriptor ... descriptors) {
        super(xOffset, yOffset, xOffset, yOffset, width, height, trueHeight, descriptors);
        this.fluid = fluid;
    }

    @Override
    public void render(GuiGraphics graphics, int wrapperX, int wrapperY, int xShift, int guiWidth, int guiHeight, Page page) {
        ResourceLocation texture = IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        RenderingUtils.setShaderColor(new Color(IClientFluidTypeExtensions.of((Fluid)this.fluid).getTintColor()));
        graphics.m_280159_(guiWidth + wrapperX + xShift, guiHeight + wrapperY, 0, this.width, this.height, sprite);
        RenderingUtils.resetShaderColor();
    }
}

